/* This file is generated by venus-protocol.  See vn_protocol_driver.h. */

/*
 * Copyright 2020 Google LLC
 * SPDX-License-Identifier: MIT
 */

#ifndef VN_PROTOCOL_DRIVER_DEVICE_MEMORY_H
#define VN_PROTOCOL_DRIVER_DEVICE_MEMORY_H

#include "vn_ring.h"
#include "vn_protocol_driver_structs.h"

/*
 * These structs/unions/commands are not included
 *
 *   VkImportMemoryFdInfoKHR
 *   vkMapMemory
 *   vkGetMemoryFdKHR
 *   vkGetMemoryFdPropertiesKHR
 */

/* struct VkExportMemoryAllocateInfo chain */

static inline size_t
vn_sizeof_VkExportMemoryAllocateInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkExportMemoryAllocateInfo_self(const VkExportMemoryAllocateInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags(&val->handleTypes);
    return size;
}

static inline size_t
vn_sizeof_VkExportMemoryAllocateInfo(const VkExportMemoryAllocateInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkExportMemoryAllocateInfo_pnext(val->pNext);
    size += vn_sizeof_VkExportMemoryAllocateInfo_self(val);

    return size;
}

static inline void
vn_encode_VkExportMemoryAllocateInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkExportMemoryAllocateInfo_self(struct vn_cs_encoder *enc, const VkExportMemoryAllocateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->handleTypes);
}

static inline void
vn_encode_VkExportMemoryAllocateInfo(struct vn_cs_encoder *enc, const VkExportMemoryAllocateInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO });
    vn_encode_VkExportMemoryAllocateInfo_pnext(enc, val->pNext);
    vn_encode_VkExportMemoryAllocateInfo_self(enc, val);
}

/* struct VkMemoryAllocateFlagsInfo chain */

static inline size_t
vn_sizeof_VkMemoryAllocateFlagsInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkMemoryAllocateFlagsInfo_self(const VkMemoryAllocateFlagsInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags(&val->flags);
    size += vn_sizeof_uint32_t(&val->deviceMask);
    return size;
}

static inline size_t
vn_sizeof_VkMemoryAllocateFlagsInfo(const VkMemoryAllocateFlagsInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkMemoryAllocateFlagsInfo_pnext(val->pNext);
    size += vn_sizeof_VkMemoryAllocateFlagsInfo_self(val);

    return size;
}

static inline void
vn_encode_VkMemoryAllocateFlagsInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkMemoryAllocateFlagsInfo_self(struct vn_cs_encoder *enc, const VkMemoryAllocateFlagsInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->flags);
    vn_encode_uint32_t(enc, &val->deviceMask);
}

static inline void
vn_encode_VkMemoryAllocateFlagsInfo(struct vn_cs_encoder *enc, const VkMemoryAllocateFlagsInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_FLAGS_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_FLAGS_INFO });
    vn_encode_VkMemoryAllocateFlagsInfo_pnext(enc, val->pNext);
    vn_encode_VkMemoryAllocateFlagsInfo_self(enc, val);
}

/* struct VkMemoryDedicatedAllocateInfo chain */

static inline size_t
vn_sizeof_VkMemoryDedicatedAllocateInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkMemoryDedicatedAllocateInfo_self(const VkMemoryDedicatedAllocateInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkImage(&val->image);
    size += vn_sizeof_VkBuffer(&val->buffer);
    return size;
}

static inline size_t
vn_sizeof_VkMemoryDedicatedAllocateInfo(const VkMemoryDedicatedAllocateInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkMemoryDedicatedAllocateInfo_pnext(val->pNext);
    size += vn_sizeof_VkMemoryDedicatedAllocateInfo_self(val);

    return size;
}

static inline void
vn_encode_VkMemoryDedicatedAllocateInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkMemoryDedicatedAllocateInfo_self(struct vn_cs_encoder *enc, const VkMemoryDedicatedAllocateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkImage(enc, &val->image);
    vn_encode_VkBuffer(enc, &val->buffer);
}

static inline void
vn_encode_VkMemoryDedicatedAllocateInfo(struct vn_cs_encoder *enc, const VkMemoryDedicatedAllocateInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_MEMORY_DEDICATED_ALLOCATE_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_MEMORY_DEDICATED_ALLOCATE_INFO });
    vn_encode_VkMemoryDedicatedAllocateInfo_pnext(enc, val->pNext);
    vn_encode_VkMemoryDedicatedAllocateInfo_self(enc, val);
}

/* struct VkMemoryOpaqueCaptureAddressAllocateInfo chain */

static inline size_t
vn_sizeof_VkMemoryOpaqueCaptureAddressAllocateInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkMemoryOpaqueCaptureAddressAllocateInfo_self(const VkMemoryOpaqueCaptureAddressAllocateInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint64_t(&val->opaqueCaptureAddress);
    return size;
}

static inline size_t
vn_sizeof_VkMemoryOpaqueCaptureAddressAllocateInfo(const VkMemoryOpaqueCaptureAddressAllocateInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkMemoryOpaqueCaptureAddressAllocateInfo_pnext(val->pNext);
    size += vn_sizeof_VkMemoryOpaqueCaptureAddressAllocateInfo_self(val);

    return size;
}

static inline void
vn_encode_VkMemoryOpaqueCaptureAddressAllocateInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkMemoryOpaqueCaptureAddressAllocateInfo_self(struct vn_cs_encoder *enc, const VkMemoryOpaqueCaptureAddressAllocateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint64_t(enc, &val->opaqueCaptureAddress);
}

static inline void
vn_encode_VkMemoryOpaqueCaptureAddressAllocateInfo(struct vn_cs_encoder *enc, const VkMemoryOpaqueCaptureAddressAllocateInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_MEMORY_OPAQUE_CAPTURE_ADDRESS_ALLOCATE_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_MEMORY_OPAQUE_CAPTURE_ADDRESS_ALLOCATE_INFO });
    vn_encode_VkMemoryOpaqueCaptureAddressAllocateInfo_pnext(enc, val->pNext);
    vn_encode_VkMemoryOpaqueCaptureAddressAllocateInfo_self(enc, val);
}

/* struct VkImportMemoryResourceInfoMESA chain */

static inline size_t
vn_sizeof_VkImportMemoryResourceInfoMESA_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkImportMemoryResourceInfoMESA_self(const VkImportMemoryResourceInfoMESA *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint32_t(&val->resourceId);
    return size;
}

static inline size_t
vn_sizeof_VkImportMemoryResourceInfoMESA(const VkImportMemoryResourceInfoMESA *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkImportMemoryResourceInfoMESA_pnext(val->pNext);
    size += vn_sizeof_VkImportMemoryResourceInfoMESA_self(val);

    return size;
}

static inline void
vn_encode_VkImportMemoryResourceInfoMESA_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkImportMemoryResourceInfoMESA_self(struct vn_cs_encoder *enc, const VkImportMemoryResourceInfoMESA *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->resourceId);
}

static inline void
vn_encode_VkImportMemoryResourceInfoMESA(struct vn_cs_encoder *enc, const VkImportMemoryResourceInfoMESA *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_IMPORT_MEMORY_RESOURCE_INFO_MESA);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_IMPORT_MEMORY_RESOURCE_INFO_MESA });
    vn_encode_VkImportMemoryResourceInfoMESA_pnext(enc, val->pNext);
    vn_encode_VkImportMemoryResourceInfoMESA_self(enc, val);
}

/* struct VkMemoryAllocateInfo chain */

static inline size_t
vn_sizeof_VkMemoryAllocateInfo_pnext(const void *val)
{
    const VkBaseInStructure *pnext = val;
    size_t size = 0;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkMemoryAllocateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkExportMemoryAllocateInfo_self((const VkExportMemoryAllocateInfo *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_FLAGS_INFO:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkMemoryAllocateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkMemoryAllocateFlagsInfo_self((const VkMemoryAllocateFlagsInfo *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_MEMORY_DEDICATED_ALLOCATE_INFO:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkMemoryAllocateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkMemoryDedicatedAllocateInfo_self((const VkMemoryDedicatedAllocateInfo *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_MEMORY_OPAQUE_CAPTURE_ADDRESS_ALLOCATE_INFO:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkMemoryAllocateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkMemoryOpaqueCaptureAddressAllocateInfo_self((const VkMemoryOpaqueCaptureAddressAllocateInfo *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_IMPORT_MEMORY_RESOURCE_INFO_MESA:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkMemoryAllocateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkImportMemoryResourceInfoMESA_self((const VkImportMemoryResourceInfoMESA *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_IMPORT_MEMORY_FD_INFO_KHR:
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkMemoryAllocateInfo_self(const VkMemoryAllocateInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkDeviceSize(&val->allocationSize);
    size += vn_sizeof_uint32_t(&val->memoryTypeIndex);
    return size;
}

static inline size_t
vn_sizeof_VkMemoryAllocateInfo(const VkMemoryAllocateInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkMemoryAllocateInfo_pnext(val->pNext);
    size += vn_sizeof_VkMemoryAllocateInfo_self(val);

    return size;
}

static inline void
vn_encode_VkMemoryAllocateInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    const VkBaseInStructure *pnext = val;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkMemoryAllocateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkExportMemoryAllocateInfo_self(enc, (const VkExportMemoryAllocateInfo *)pnext);
            return;
        case VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_FLAGS_INFO:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkMemoryAllocateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkMemoryAllocateFlagsInfo_self(enc, (const VkMemoryAllocateFlagsInfo *)pnext);
            return;
        case VK_STRUCTURE_TYPE_MEMORY_DEDICATED_ALLOCATE_INFO:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkMemoryAllocateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkMemoryDedicatedAllocateInfo_self(enc, (const VkMemoryDedicatedAllocateInfo *)pnext);
            return;
        case VK_STRUCTURE_TYPE_MEMORY_OPAQUE_CAPTURE_ADDRESS_ALLOCATE_INFO:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkMemoryAllocateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkMemoryOpaqueCaptureAddressAllocateInfo_self(enc, (const VkMemoryOpaqueCaptureAddressAllocateInfo *)pnext);
            return;
        case VK_STRUCTURE_TYPE_IMPORT_MEMORY_RESOURCE_INFO_MESA:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkMemoryAllocateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkImportMemoryResourceInfoMESA_self(enc, (const VkImportMemoryResourceInfoMESA *)pnext);
            return;
        case VK_STRUCTURE_TYPE_IMPORT_MEMORY_FD_INFO_KHR:
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkMemoryAllocateInfo_self(struct vn_cs_encoder *enc, const VkMemoryAllocateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkDeviceSize(enc, &val->allocationSize);
    vn_encode_uint32_t(enc, &val->memoryTypeIndex);
}

static inline void
vn_encode_VkMemoryAllocateInfo(struct vn_cs_encoder *enc, const VkMemoryAllocateInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_INFO });
    vn_encode_VkMemoryAllocateInfo_pnext(enc, val->pNext);
    vn_encode_VkMemoryAllocateInfo_self(enc, val);
}

/* struct VkMappedMemoryRange chain */

static inline size_t
vn_sizeof_VkMappedMemoryRange_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkMappedMemoryRange_self(const VkMappedMemoryRange *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkDeviceMemory(&val->memory);
    size += vn_sizeof_VkDeviceSize(&val->offset);
    size += vn_sizeof_VkDeviceSize(&val->size);
    return size;
}

static inline size_t
vn_sizeof_VkMappedMemoryRange(const VkMappedMemoryRange *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkMappedMemoryRange_pnext(val->pNext);
    size += vn_sizeof_VkMappedMemoryRange_self(val);

    return size;
}

static inline void
vn_encode_VkMappedMemoryRange_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkMappedMemoryRange_self(struct vn_cs_encoder *enc, const VkMappedMemoryRange *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkDeviceMemory(enc, &val->memory);
    vn_encode_VkDeviceSize(enc, &val->offset);
    vn_encode_VkDeviceSize(enc, &val->size);
}

static inline void
vn_encode_VkMappedMemoryRange(struct vn_cs_encoder *enc, const VkMappedMemoryRange *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_MAPPED_MEMORY_RANGE);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_MAPPED_MEMORY_RANGE });
    vn_encode_VkMappedMemoryRange_pnext(enc, val->pNext);
    vn_encode_VkMappedMemoryRange_self(enc, val);
}

/* struct VkDeviceMemoryOpaqueCaptureAddressInfo chain */

static inline size_t
vn_sizeof_VkDeviceMemoryOpaqueCaptureAddressInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkDeviceMemoryOpaqueCaptureAddressInfo_self(const VkDeviceMemoryOpaqueCaptureAddressInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkDeviceMemory(&val->memory);
    return size;
}

static inline size_t
vn_sizeof_VkDeviceMemoryOpaqueCaptureAddressInfo(const VkDeviceMemoryOpaqueCaptureAddressInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkDeviceMemoryOpaqueCaptureAddressInfo_pnext(val->pNext);
    size += vn_sizeof_VkDeviceMemoryOpaqueCaptureAddressInfo_self(val);

    return size;
}

static inline void
vn_encode_VkDeviceMemoryOpaqueCaptureAddressInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkDeviceMemoryOpaqueCaptureAddressInfo_self(struct vn_cs_encoder *enc, const VkDeviceMemoryOpaqueCaptureAddressInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkDeviceMemory(enc, &val->memory);
}

static inline void
vn_encode_VkDeviceMemoryOpaqueCaptureAddressInfo(struct vn_cs_encoder *enc, const VkDeviceMemoryOpaqueCaptureAddressInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_DEVICE_MEMORY_OPAQUE_CAPTURE_ADDRESS_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_DEVICE_MEMORY_OPAQUE_CAPTURE_ADDRESS_INFO });
    vn_encode_VkDeviceMemoryOpaqueCaptureAddressInfo_pnext(enc, val->pNext);
    vn_encode_VkDeviceMemoryOpaqueCaptureAddressInfo_self(enc, val);
}

/* struct VkMemoryResourceAllocationSizePropertiesMESA chain */

static inline size_t
vn_sizeof_VkMemoryResourceAllocationSizePropertiesMESA_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkMemoryResourceAllocationSizePropertiesMESA_self(const VkMemoryResourceAllocationSizePropertiesMESA *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint64_t(&val->allocationSize);
    return size;
}

static inline size_t
vn_sizeof_VkMemoryResourceAllocationSizePropertiesMESA(const VkMemoryResourceAllocationSizePropertiesMESA *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkMemoryResourceAllocationSizePropertiesMESA_pnext(val->pNext);
    size += vn_sizeof_VkMemoryResourceAllocationSizePropertiesMESA_self(val);

    return size;
}

static inline void
vn_decode_VkMemoryResourceAllocationSizePropertiesMESA_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkMemoryResourceAllocationSizePropertiesMESA_self(struct vn_cs_decoder *dec, VkMemoryResourceAllocationSizePropertiesMESA *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint64_t(dec, &val->allocationSize);
}

static inline void
vn_decode_VkMemoryResourceAllocationSizePropertiesMESA(struct vn_cs_decoder *dec, VkMemoryResourceAllocationSizePropertiesMESA *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_MEMORY_RESOURCE_ALLOCATION_SIZE_PROPERTIES_MESA);

    assert(val->sType == stype);
    vn_decode_VkMemoryResourceAllocationSizePropertiesMESA_pnext(dec, val->pNext);
    vn_decode_VkMemoryResourceAllocationSizePropertiesMESA_self(dec, val);
}

static inline size_t
vn_sizeof_VkMemoryResourceAllocationSizePropertiesMESA_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkMemoryResourceAllocationSizePropertiesMESA_self_partial(const VkMemoryResourceAllocationSizePropertiesMESA *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->allocationSize */
    return size;
}

static inline size_t
vn_sizeof_VkMemoryResourceAllocationSizePropertiesMESA_partial(const VkMemoryResourceAllocationSizePropertiesMESA *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkMemoryResourceAllocationSizePropertiesMESA_pnext_partial(val->pNext);
    size += vn_sizeof_VkMemoryResourceAllocationSizePropertiesMESA_self_partial(val);

    return size;
}

static inline void
vn_encode_VkMemoryResourceAllocationSizePropertiesMESA_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkMemoryResourceAllocationSizePropertiesMESA_self_partial(struct vn_cs_encoder *enc, const VkMemoryResourceAllocationSizePropertiesMESA *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->allocationSize */
}

static inline void
vn_encode_VkMemoryResourceAllocationSizePropertiesMESA_partial(struct vn_cs_encoder *enc, const VkMemoryResourceAllocationSizePropertiesMESA *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_MEMORY_RESOURCE_ALLOCATION_SIZE_PROPERTIES_MESA);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_MEMORY_RESOURCE_ALLOCATION_SIZE_PROPERTIES_MESA });
    vn_encode_VkMemoryResourceAllocationSizePropertiesMESA_pnext_partial(enc, val->pNext);
    vn_encode_VkMemoryResourceAllocationSizePropertiesMESA_self_partial(enc, val);
}

/* struct VkMemoryResourcePropertiesMESA chain */

static inline size_t
vn_sizeof_VkMemoryResourcePropertiesMESA_pnext(const void *val)
{
    const VkBaseInStructure *pnext = val;
    size_t size = 0;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_MEMORY_RESOURCE_ALLOCATION_SIZE_PROPERTIES_MESA:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkMemoryResourcePropertiesMESA_pnext(pnext->pNext);
            size += vn_sizeof_VkMemoryResourceAllocationSizePropertiesMESA_self((const VkMemoryResourceAllocationSizePropertiesMESA *)pnext);
            return size;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkMemoryResourcePropertiesMESA_self(const VkMemoryResourcePropertiesMESA *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint32_t(&val->memoryTypeBits);
    return size;
}

static inline size_t
vn_sizeof_VkMemoryResourcePropertiesMESA(const VkMemoryResourcePropertiesMESA *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkMemoryResourcePropertiesMESA_pnext(val->pNext);
    size += vn_sizeof_VkMemoryResourcePropertiesMESA_self(val);

    return size;
}

static inline void
vn_decode_VkMemoryResourcePropertiesMESA_pnext(struct vn_cs_decoder *dec, const void *val)
{
    VkBaseOutStructure *pnext = (VkBaseOutStructure *)val;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return;

    vn_decode_VkStructureType(dec, &stype);
    while (true) {
        assert(pnext);
        if (pnext->sType == stype)
            break;

        pnext = pnext->pNext;
    }

    switch ((int32_t)pnext->sType) {
    case VK_STRUCTURE_TYPE_MEMORY_RESOURCE_ALLOCATION_SIZE_PROPERTIES_MESA:
        vn_decode_VkMemoryResourcePropertiesMESA_pnext(dec, pnext->pNext);
        vn_decode_VkMemoryResourceAllocationSizePropertiesMESA_self(dec, (VkMemoryResourceAllocationSizePropertiesMESA *)pnext);
        break;
    default:
        assert(false);
        break;
    }
}

static inline void
vn_decode_VkMemoryResourcePropertiesMESA_self(struct vn_cs_decoder *dec, VkMemoryResourcePropertiesMESA *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint32_t(dec, &val->memoryTypeBits);
}

static inline void
vn_decode_VkMemoryResourcePropertiesMESA(struct vn_cs_decoder *dec, VkMemoryResourcePropertiesMESA *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_MEMORY_RESOURCE_PROPERTIES_MESA);

    assert(val->sType == stype);
    vn_decode_VkMemoryResourcePropertiesMESA_pnext(dec, val->pNext);
    vn_decode_VkMemoryResourcePropertiesMESA_self(dec, val);
}

static inline size_t
vn_sizeof_VkMemoryResourcePropertiesMESA_pnext_partial(const void *val)
{
    const VkBaseInStructure *pnext = val;
    size_t size = 0;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_MEMORY_RESOURCE_ALLOCATION_SIZE_PROPERTIES_MESA:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkMemoryResourcePropertiesMESA_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkMemoryResourceAllocationSizePropertiesMESA_self_partial((const VkMemoryResourceAllocationSizePropertiesMESA *)pnext);
            return size;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkMemoryResourcePropertiesMESA_self_partial(const VkMemoryResourcePropertiesMESA *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->memoryTypeBits */
    return size;
}

static inline size_t
vn_sizeof_VkMemoryResourcePropertiesMESA_partial(const VkMemoryResourcePropertiesMESA *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkMemoryResourcePropertiesMESA_pnext_partial(val->pNext);
    size += vn_sizeof_VkMemoryResourcePropertiesMESA_self_partial(val);

    return size;
}

static inline void
vn_encode_VkMemoryResourcePropertiesMESA_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    const VkBaseInStructure *pnext = val;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_MEMORY_RESOURCE_ALLOCATION_SIZE_PROPERTIES_MESA:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkMemoryResourcePropertiesMESA_pnext_partial(enc, pnext->pNext);
            vn_encode_VkMemoryResourceAllocationSizePropertiesMESA_self_partial(enc, (const VkMemoryResourceAllocationSizePropertiesMESA *)pnext);
            return;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkMemoryResourcePropertiesMESA_self_partial(struct vn_cs_encoder *enc, const VkMemoryResourcePropertiesMESA *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->memoryTypeBits */
}

static inline void
vn_encode_VkMemoryResourcePropertiesMESA_partial(struct vn_cs_encoder *enc, const VkMemoryResourcePropertiesMESA *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_MEMORY_RESOURCE_PROPERTIES_MESA);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_MEMORY_RESOURCE_PROPERTIES_MESA });
    vn_encode_VkMemoryResourcePropertiesMESA_pnext_partial(enc, val->pNext);
    vn_encode_VkMemoryResourcePropertiesMESA_self_partial(enc, val);
}

static inline size_t vn_sizeof_vkAllocateMemory(VkDevice device, const VkMemoryAllocateInfo* pAllocateInfo, const VkAllocationCallbacks* pAllocator, VkDeviceMemory* pMemory)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkAllocateMemory_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_simple_pointer(pAllocateInfo);
    if (pAllocateInfo)
        cmd_size += vn_sizeof_VkMemoryAllocateInfo(pAllocateInfo);
    cmd_size += vn_sizeof_simple_pointer(pAllocator);
    if (pAllocator)
        assert(false);
    cmd_size += vn_sizeof_simple_pointer(pMemory);
    if (pMemory)
        cmd_size += vn_sizeof_VkDeviceMemory(pMemory);

    return cmd_size;
}

static inline void vn_encode_vkAllocateMemory(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkMemoryAllocateInfo* pAllocateInfo, const VkAllocationCallbacks* pAllocator, VkDeviceMemory* pMemory)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkAllocateMemory_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    if (vn_encode_simple_pointer(enc, pAllocateInfo))
        vn_encode_VkMemoryAllocateInfo(enc, pAllocateInfo);
    if (vn_encode_simple_pointer(enc, pAllocator))
        assert(false);
    if (vn_encode_simple_pointer(enc, pMemory))
        vn_encode_VkDeviceMemory(enc, pMemory);
}

static inline size_t vn_sizeof_vkAllocateMemory_reply(VkDevice device, const VkMemoryAllocateInfo* pAllocateInfo, const VkAllocationCallbacks* pAllocator, VkDeviceMemory* pMemory)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkAllocateMemory_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    VkResult ret;
    cmd_size += vn_sizeof_VkResult(&ret);
    /* skip device */
    /* skip pAllocateInfo */
    /* skip pAllocator */
    cmd_size += vn_sizeof_simple_pointer(pMemory);
    if (pMemory)
        cmd_size += vn_sizeof_VkDeviceMemory(pMemory);

    return cmd_size;
}

static inline VkResult vn_decode_vkAllocateMemory_reply(struct vn_cs_decoder *dec, VkDevice device, const VkMemoryAllocateInfo* pAllocateInfo, const VkAllocationCallbacks* pAllocator, VkDeviceMemory* pMemory)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkAllocateMemory_EXT);

    VkResult ret;
    vn_decode_VkResult(dec, &ret);
    /* skip device */
    /* skip pAllocateInfo */
    /* skip pAllocator */
    if (vn_decode_simple_pointer(dec)) {
        vn_decode_VkDeviceMemory(dec, pMemory);
    } else {
        pMemory = NULL;
    }

    return ret;
}

static inline size_t vn_sizeof_vkFreeMemory(VkDevice device, VkDeviceMemory memory, const VkAllocationCallbacks* pAllocator)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkFreeMemory_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_VkDeviceMemory(&memory);
    cmd_size += vn_sizeof_simple_pointer(pAllocator);
    if (pAllocator)
        assert(false);

    return cmd_size;
}

static inline void vn_encode_vkFreeMemory(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, VkDeviceMemory memory, const VkAllocationCallbacks* pAllocator)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkFreeMemory_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    vn_encode_VkDeviceMemory(enc, &memory);
    if (vn_encode_simple_pointer(enc, pAllocator))
        assert(false);
}

static inline size_t vn_sizeof_vkFreeMemory_reply(VkDevice device, VkDeviceMemory memory, const VkAllocationCallbacks* pAllocator)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkFreeMemory_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip device */
    /* skip memory */
    /* skip pAllocator */

    return cmd_size;
}

static inline void vn_decode_vkFreeMemory_reply(struct vn_cs_decoder *dec, VkDevice device, VkDeviceMemory memory, const VkAllocationCallbacks* pAllocator)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkFreeMemory_EXT);

    /* skip device */
    /* skip memory */
    /* skip pAllocator */
}

static inline size_t vn_sizeof_vkUnmapMemory(VkDevice device, VkDeviceMemory memory)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkUnmapMemory_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_VkDeviceMemory(&memory);

    return cmd_size;
}

static inline void vn_encode_vkUnmapMemory(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, VkDeviceMemory memory)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkUnmapMemory_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    vn_encode_VkDeviceMemory(enc, &memory);
}

static inline size_t vn_sizeof_vkUnmapMemory_reply(VkDevice device, VkDeviceMemory memory)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkUnmapMemory_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip device */
    /* skip memory */

    return cmd_size;
}

static inline void vn_decode_vkUnmapMemory_reply(struct vn_cs_decoder *dec, VkDevice device, VkDeviceMemory memory)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkUnmapMemory_EXT);

    /* skip device */
    /* skip memory */
}

static inline size_t vn_sizeof_vkFlushMappedMemoryRanges(VkDevice device, uint32_t memoryRangeCount, const VkMappedMemoryRange* pMemoryRanges)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkFlushMappedMemoryRanges_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_uint32_t(&memoryRangeCount);
    if (pMemoryRanges) {
        cmd_size += vn_sizeof_array_size(memoryRangeCount);
        for (uint32_t i = 0; i < memoryRangeCount; i++)
            cmd_size += vn_sizeof_VkMappedMemoryRange(&pMemoryRanges[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkFlushMappedMemoryRanges(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, uint32_t memoryRangeCount, const VkMappedMemoryRange* pMemoryRanges)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkFlushMappedMemoryRanges_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    vn_encode_uint32_t(enc, &memoryRangeCount);
    if (pMemoryRanges) {
        vn_encode_array_size(enc, memoryRangeCount);
        for (uint32_t i = 0; i < memoryRangeCount; i++)
            vn_encode_VkMappedMemoryRange(enc, &pMemoryRanges[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkFlushMappedMemoryRanges_reply(VkDevice device, uint32_t memoryRangeCount, const VkMappedMemoryRange* pMemoryRanges)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkFlushMappedMemoryRanges_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    VkResult ret;
    cmd_size += vn_sizeof_VkResult(&ret);
    /* skip device */
    /* skip memoryRangeCount */
    /* skip pMemoryRanges */

    return cmd_size;
}

static inline VkResult vn_decode_vkFlushMappedMemoryRanges_reply(struct vn_cs_decoder *dec, VkDevice device, uint32_t memoryRangeCount, const VkMappedMemoryRange* pMemoryRanges)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkFlushMappedMemoryRanges_EXT);

    VkResult ret;
    vn_decode_VkResult(dec, &ret);
    /* skip device */
    /* skip memoryRangeCount */
    /* skip pMemoryRanges */

    return ret;
}

static inline size_t vn_sizeof_vkInvalidateMappedMemoryRanges(VkDevice device, uint32_t memoryRangeCount, const VkMappedMemoryRange* pMemoryRanges)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkInvalidateMappedMemoryRanges_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_uint32_t(&memoryRangeCount);
    if (pMemoryRanges) {
        cmd_size += vn_sizeof_array_size(memoryRangeCount);
        for (uint32_t i = 0; i < memoryRangeCount; i++)
            cmd_size += vn_sizeof_VkMappedMemoryRange(&pMemoryRanges[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkInvalidateMappedMemoryRanges(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, uint32_t memoryRangeCount, const VkMappedMemoryRange* pMemoryRanges)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkInvalidateMappedMemoryRanges_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    vn_encode_uint32_t(enc, &memoryRangeCount);
    if (pMemoryRanges) {
        vn_encode_array_size(enc, memoryRangeCount);
        for (uint32_t i = 0; i < memoryRangeCount; i++)
            vn_encode_VkMappedMemoryRange(enc, &pMemoryRanges[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkInvalidateMappedMemoryRanges_reply(VkDevice device, uint32_t memoryRangeCount, const VkMappedMemoryRange* pMemoryRanges)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkInvalidateMappedMemoryRanges_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    VkResult ret;
    cmd_size += vn_sizeof_VkResult(&ret);
    /* skip device */
    /* skip memoryRangeCount */
    /* skip pMemoryRanges */

    return cmd_size;
}

static inline VkResult vn_decode_vkInvalidateMappedMemoryRanges_reply(struct vn_cs_decoder *dec, VkDevice device, uint32_t memoryRangeCount, const VkMappedMemoryRange* pMemoryRanges)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkInvalidateMappedMemoryRanges_EXT);

    VkResult ret;
    vn_decode_VkResult(dec, &ret);
    /* skip device */
    /* skip memoryRangeCount */
    /* skip pMemoryRanges */

    return ret;
}

static inline size_t vn_sizeof_vkGetDeviceMemoryCommitment(VkDevice device, VkDeviceMemory memory, VkDeviceSize* pCommittedMemoryInBytes)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetDeviceMemoryCommitment_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_VkDeviceMemory(&memory);
    cmd_size += vn_sizeof_simple_pointer(pCommittedMemoryInBytes); /* out */

    return cmd_size;
}

static inline void vn_encode_vkGetDeviceMemoryCommitment(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, VkDeviceMemory memory, VkDeviceSize* pCommittedMemoryInBytes)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetDeviceMemoryCommitment_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    vn_encode_VkDeviceMemory(enc, &memory);
    vn_encode_simple_pointer(enc, pCommittedMemoryInBytes); /* out */
}

static inline size_t vn_sizeof_vkGetDeviceMemoryCommitment_reply(VkDevice device, VkDeviceMemory memory, VkDeviceSize* pCommittedMemoryInBytes)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetDeviceMemoryCommitment_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip device */
    /* skip memory */
    cmd_size += vn_sizeof_simple_pointer(pCommittedMemoryInBytes);
    if (pCommittedMemoryInBytes)
        cmd_size += vn_sizeof_VkDeviceSize(pCommittedMemoryInBytes);

    return cmd_size;
}

static inline void vn_decode_vkGetDeviceMemoryCommitment_reply(struct vn_cs_decoder *dec, VkDevice device, VkDeviceMemory memory, VkDeviceSize* pCommittedMemoryInBytes)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkGetDeviceMemoryCommitment_EXT);

    /* skip device */
    /* skip memory */
    if (vn_decode_simple_pointer(dec)) {
        vn_decode_VkDeviceSize(dec, pCommittedMemoryInBytes);
    } else {
        pCommittedMemoryInBytes = NULL;
    }
}

static inline size_t vn_sizeof_vkGetDeviceMemoryOpaqueCaptureAddress(VkDevice device, const VkDeviceMemoryOpaqueCaptureAddressInfo* pInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetDeviceMemoryOpaqueCaptureAddress_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_simple_pointer(pInfo);
    if (pInfo)
        cmd_size += vn_sizeof_VkDeviceMemoryOpaqueCaptureAddressInfo(pInfo);

    return cmd_size;
}

static inline void vn_encode_vkGetDeviceMemoryOpaqueCaptureAddress(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkDeviceMemoryOpaqueCaptureAddressInfo* pInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetDeviceMemoryOpaqueCaptureAddress_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    if (vn_encode_simple_pointer(enc, pInfo))
        vn_encode_VkDeviceMemoryOpaqueCaptureAddressInfo(enc, pInfo);
}

static inline size_t vn_sizeof_vkGetDeviceMemoryOpaqueCaptureAddress_reply(VkDevice device, const VkDeviceMemoryOpaqueCaptureAddressInfo* pInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetDeviceMemoryOpaqueCaptureAddress_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    uint64_t ret;
    cmd_size += vn_sizeof_uint64_t(&ret);
    /* skip device */
    /* skip pInfo */

    return cmd_size;
}

static inline uint64_t vn_decode_vkGetDeviceMemoryOpaqueCaptureAddress_reply(struct vn_cs_decoder *dec, VkDevice device, const VkDeviceMemoryOpaqueCaptureAddressInfo* pInfo)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkGetDeviceMemoryOpaqueCaptureAddress_EXT);

    uint64_t ret;
    vn_decode_uint64_t(dec, &ret);
    /* skip device */
    /* skip pInfo */

    return ret;
}

static inline size_t vn_sizeof_vkGetMemoryResourcePropertiesMESA(VkDevice device, uint32_t resourceId, VkMemoryResourcePropertiesMESA* pMemoryResourceProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetMemoryResourcePropertiesMESA_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_uint32_t(&resourceId);
    cmd_size += vn_sizeof_simple_pointer(pMemoryResourceProperties);
    if (pMemoryResourceProperties)
        cmd_size += vn_sizeof_VkMemoryResourcePropertiesMESA_partial(pMemoryResourceProperties);

    return cmd_size;
}

static inline void vn_encode_vkGetMemoryResourcePropertiesMESA(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, uint32_t resourceId, VkMemoryResourcePropertiesMESA* pMemoryResourceProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetMemoryResourcePropertiesMESA_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    vn_encode_uint32_t(enc, &resourceId);
    if (vn_encode_simple_pointer(enc, pMemoryResourceProperties))
        vn_encode_VkMemoryResourcePropertiesMESA_partial(enc, pMemoryResourceProperties);
}

static inline size_t vn_sizeof_vkGetMemoryResourcePropertiesMESA_reply(VkDevice device, uint32_t resourceId, VkMemoryResourcePropertiesMESA* pMemoryResourceProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetMemoryResourcePropertiesMESA_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    VkResult ret;
    cmd_size += vn_sizeof_VkResult(&ret);
    /* skip device */
    /* skip resourceId */
    cmd_size += vn_sizeof_simple_pointer(pMemoryResourceProperties);
    if (pMemoryResourceProperties)
        cmd_size += vn_sizeof_VkMemoryResourcePropertiesMESA(pMemoryResourceProperties);

    return cmd_size;
}

static inline VkResult vn_decode_vkGetMemoryResourcePropertiesMESA_reply(struct vn_cs_decoder *dec, VkDevice device, uint32_t resourceId, VkMemoryResourcePropertiesMESA* pMemoryResourceProperties)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkGetMemoryResourcePropertiesMESA_EXT);

    VkResult ret;
    vn_decode_VkResult(dec, &ret);
    /* skip device */
    /* skip resourceId */
    if (vn_decode_simple_pointer(dec)) {
        vn_decode_VkMemoryResourcePropertiesMESA(dec, pMemoryResourceProperties);
    } else {
        pMemoryResourceProperties = NULL;
    }

    return ret;
}

static inline void vn_submit_vkAllocateMemory(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkMemoryAllocateInfo* pAllocateInfo, const VkAllocationCallbacks* pAllocator, VkDeviceMemory* pMemory, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkAllocateMemory(device, pAllocateInfo, pAllocator, pMemory);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkAllocateMemory_reply(device, pAllocateInfo, pAllocator, pMemory) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkAllocateMemory(enc, cmd_flags, device, pAllocateInfo, pAllocator, pMemory);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkFreeMemory(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkDevice device, VkDeviceMemory memory, const VkAllocationCallbacks* pAllocator, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkFreeMemory(device, memory, pAllocator);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkFreeMemory_reply(device, memory, pAllocator) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkFreeMemory(enc, cmd_flags, device, memory, pAllocator);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkUnmapMemory(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkDevice device, VkDeviceMemory memory, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkUnmapMemory(device, memory);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkUnmapMemory_reply(device, memory) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkUnmapMemory(enc, cmd_flags, device, memory);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkFlushMappedMemoryRanges(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkDevice device, uint32_t memoryRangeCount, const VkMappedMemoryRange* pMemoryRanges, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkFlushMappedMemoryRanges(device, memoryRangeCount, pMemoryRanges);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkFlushMappedMemoryRanges_reply(device, memoryRangeCount, pMemoryRanges) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkFlushMappedMemoryRanges(enc, cmd_flags, device, memoryRangeCount, pMemoryRanges);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkInvalidateMappedMemoryRanges(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkDevice device, uint32_t memoryRangeCount, const VkMappedMemoryRange* pMemoryRanges, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkInvalidateMappedMemoryRanges(device, memoryRangeCount, pMemoryRanges);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkInvalidateMappedMemoryRanges_reply(device, memoryRangeCount, pMemoryRanges) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkInvalidateMappedMemoryRanges(enc, cmd_flags, device, memoryRangeCount, pMemoryRanges);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkGetDeviceMemoryCommitment(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkDevice device, VkDeviceMemory memory, VkDeviceSize* pCommittedMemoryInBytes, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkGetDeviceMemoryCommitment(device, memory, pCommittedMemoryInBytes);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkGetDeviceMemoryCommitment_reply(device, memory, pCommittedMemoryInBytes) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkGetDeviceMemoryCommitment(enc, cmd_flags, device, memory, pCommittedMemoryInBytes);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkGetDeviceMemoryOpaqueCaptureAddress(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkDeviceMemoryOpaqueCaptureAddressInfo* pInfo, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkGetDeviceMemoryOpaqueCaptureAddress(device, pInfo);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkGetDeviceMemoryOpaqueCaptureAddress_reply(device, pInfo) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkGetDeviceMemoryOpaqueCaptureAddress(enc, cmd_flags, device, pInfo);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkGetMemoryResourcePropertiesMESA(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkDevice device, uint32_t resourceId, VkMemoryResourcePropertiesMESA* pMemoryResourceProperties, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkGetMemoryResourcePropertiesMESA(device, resourceId, pMemoryResourceProperties);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkGetMemoryResourcePropertiesMESA_reply(device, resourceId, pMemoryResourceProperties) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkGetMemoryResourcePropertiesMESA(enc, cmd_flags, device, resourceId, pMemoryResourceProperties);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline VkResult vn_call_vkAllocateMemory(struct vn_ring *vn_ring, VkDevice device, const VkMemoryAllocateInfo* pAllocateInfo, const VkAllocationCallbacks* pAllocator, VkDeviceMemory* pMemory)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkAllocateMemory(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, pAllocateInfo, pAllocator, pMemory, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        const VkResult ret = vn_decode_vkAllocateMemory_reply(dec, device, pAllocateInfo, pAllocator, pMemory);
        vn_ring_free_command_reply(vn_ring, &submit);
        return ret;
    } else {
        return VK_ERROR_OUT_OF_HOST_MEMORY;
    }
}

static inline void vn_async_vkAllocateMemory(struct vn_ring *vn_ring, VkDevice device, const VkMemoryAllocateInfo* pAllocateInfo, const VkAllocationCallbacks* pAllocator, VkDeviceMemory* pMemory)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkAllocateMemory(vn_ring, 0, device, pAllocateInfo, pAllocator, pMemory, &submit);
}

static inline void vn_call_vkFreeMemory(struct vn_ring *vn_ring, VkDevice device, VkDeviceMemory memory, const VkAllocationCallbacks* pAllocator)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkFreeMemory(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, memory, pAllocator, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkFreeMemory_reply(dec, device, memory, pAllocator);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkFreeMemory(struct vn_ring *vn_ring, VkDevice device, VkDeviceMemory memory, const VkAllocationCallbacks* pAllocator)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkFreeMemory(vn_ring, 0, device, memory, pAllocator, &submit);
}

static inline void vn_call_vkUnmapMemory(struct vn_ring *vn_ring, VkDevice device, VkDeviceMemory memory)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkUnmapMemory(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, memory, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkUnmapMemory_reply(dec, device, memory);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkUnmapMemory(struct vn_ring *vn_ring, VkDevice device, VkDeviceMemory memory)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkUnmapMemory(vn_ring, 0, device, memory, &submit);
}

static inline VkResult vn_call_vkFlushMappedMemoryRanges(struct vn_ring *vn_ring, VkDevice device, uint32_t memoryRangeCount, const VkMappedMemoryRange* pMemoryRanges)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkFlushMappedMemoryRanges(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, memoryRangeCount, pMemoryRanges, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        const VkResult ret = vn_decode_vkFlushMappedMemoryRanges_reply(dec, device, memoryRangeCount, pMemoryRanges);
        vn_ring_free_command_reply(vn_ring, &submit);
        return ret;
    } else {
        return VK_ERROR_OUT_OF_HOST_MEMORY;
    }
}

static inline void vn_async_vkFlushMappedMemoryRanges(struct vn_ring *vn_ring, VkDevice device, uint32_t memoryRangeCount, const VkMappedMemoryRange* pMemoryRanges)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkFlushMappedMemoryRanges(vn_ring, 0, device, memoryRangeCount, pMemoryRanges, &submit);
}

static inline VkResult vn_call_vkInvalidateMappedMemoryRanges(struct vn_ring *vn_ring, VkDevice device, uint32_t memoryRangeCount, const VkMappedMemoryRange* pMemoryRanges)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkInvalidateMappedMemoryRanges(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, memoryRangeCount, pMemoryRanges, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        const VkResult ret = vn_decode_vkInvalidateMappedMemoryRanges_reply(dec, device, memoryRangeCount, pMemoryRanges);
        vn_ring_free_command_reply(vn_ring, &submit);
        return ret;
    } else {
        return VK_ERROR_OUT_OF_HOST_MEMORY;
    }
}

static inline void vn_async_vkInvalidateMappedMemoryRanges(struct vn_ring *vn_ring, VkDevice device, uint32_t memoryRangeCount, const VkMappedMemoryRange* pMemoryRanges)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkInvalidateMappedMemoryRanges(vn_ring, 0, device, memoryRangeCount, pMemoryRanges, &submit);
}

static inline void vn_call_vkGetDeviceMemoryCommitment(struct vn_ring *vn_ring, VkDevice device, VkDeviceMemory memory, VkDeviceSize* pCommittedMemoryInBytes)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkGetDeviceMemoryCommitment(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, memory, pCommittedMemoryInBytes, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkGetDeviceMemoryCommitment_reply(dec, device, memory, pCommittedMemoryInBytes);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkGetDeviceMemoryCommitment(struct vn_ring *vn_ring, VkDevice device, VkDeviceMemory memory, VkDeviceSize* pCommittedMemoryInBytes)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkGetDeviceMemoryCommitment(vn_ring, 0, device, memory, pCommittedMemoryInBytes, &submit);
}

static inline uint64_t vn_call_vkGetDeviceMemoryOpaqueCaptureAddress(struct vn_ring *vn_ring, VkDevice device, const VkDeviceMemoryOpaqueCaptureAddressInfo* pInfo)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkGetDeviceMemoryOpaqueCaptureAddress(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, pInfo, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        const uint64_t ret = vn_decode_vkGetDeviceMemoryOpaqueCaptureAddress_reply(dec, device, pInfo);
        vn_ring_free_command_reply(vn_ring, &submit);
        return ret;
    } else {
        return VK_ERROR_OUT_OF_HOST_MEMORY;
    }
}

static inline void vn_async_vkGetDeviceMemoryOpaqueCaptureAddress(struct vn_ring *vn_ring, VkDevice device, const VkDeviceMemoryOpaqueCaptureAddressInfo* pInfo)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkGetDeviceMemoryOpaqueCaptureAddress(vn_ring, 0, device, pInfo, &submit);
}

static inline VkResult vn_call_vkGetMemoryResourcePropertiesMESA(struct vn_ring *vn_ring, VkDevice device, uint32_t resourceId, VkMemoryResourcePropertiesMESA* pMemoryResourceProperties)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkGetMemoryResourcePropertiesMESA(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, resourceId, pMemoryResourceProperties, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        const VkResult ret = vn_decode_vkGetMemoryResourcePropertiesMESA_reply(dec, device, resourceId, pMemoryResourceProperties);
        vn_ring_free_command_reply(vn_ring, &submit);
        return ret;
    } else {
        return VK_ERROR_OUT_OF_HOST_MEMORY;
    }
}

static inline void vn_async_vkGetMemoryResourcePropertiesMESA(struct vn_ring *vn_ring, VkDevice device, uint32_t resourceId, VkMemoryResourcePropertiesMESA* pMemoryResourceProperties)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkGetMemoryResourcePropertiesMESA(vn_ring, 0, device, resourceId, pMemoryResourceProperties, &submit);
}

#endif /* VN_PROTOCOL_DRIVER_DEVICE_MEMORY_H */
