/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.webapp.util;

import info.aduna.text.StringUtil;
import info.aduna.webapp.util.HttpServerUtil;
import info.aduna.webapp.util.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeaderElement {
    private String _value;
    private List<Parameter> _parameters;

    public static HeaderElement parse(String encodedValue) {
        HeaderElement result = new HeaderElement();
        List<String> tokens = HttpServerUtil.splitHeaderString(encodedValue, ';');
        if (!tokens.isEmpty()) {
            String token = tokens.get(0);
            token = StringUtil.trimDoubleQuotes(token.trim());
            result.setValue(token);
            for (int i = 1; i < tokens.size(); ++i) {
                token = tokens.get(i);
                int splitIdx = token.indexOf(61);
                if (splitIdx == -1) {
                    if ((token = StringUtil.trimDoubleQuotes(token.trim())).length() <= 0) continue;
                    result.addParameter(token);
                    continue;
                }
                String key = token.substring(0, splitIdx).trim();
                String value = token.substring(splitIdx + 1).trim();
                value = StringUtil.trimDoubleQuotes(value);
                result.addParameter(key, value);
            }
        }
        return result;
    }

    public HeaderElement() {
        this("");
    }

    public HeaderElement(String value) {
        this.setValue(value);
        this._parameters = new ArrayList<Parameter>();
    }

    public String getValue() {
        return this._value;
    }

    public void setValue(String value) {
        this._value = value;
    }

    public int getParameterCount() {
        return this._parameters.size();
    }

    public Parameter getParameter(int i) {
        return this._parameters.get(i);
    }

    public Parameter getParameter(String key) {
        for (int i = 0; i < this._parameters.size(); ++i) {
            Parameter param = this._parameters.get(i);
            if (!param.getKey().equals(key)) continue;
            return param;
        }
        return null;
    }

    public String getParameterValue(String key) {
        Parameter param = this.getParameter(key);
        if (param != null) {
            return param.getValue();
        }
        return null;
    }

    public List<Parameter> getParameters() {
        return Collections.unmodifiableList(this._parameters);
    }

    public void addParameter(String key) {
        this.addParameter(key, null);
    }

    public void addParameter(String key, String value) {
        this.addParameter(new Parameter(key, value));
    }

    public void addParameter(Parameter param) {
        this._parameters.add(param);
    }

    public Parameter removeParameter(int idx) {
        return this._parameters.remove(idx);
    }

    public boolean removeParameter(Parameter param) {
        return this._parameters.remove(param);
    }

    public boolean equals(Object obj) {
        if (obj instanceof HeaderElement) {
            HeaderElement other = (HeaderElement)obj;
            return this._value.equals(other.getValue()) && ((Object)this._parameters).equals(other.getParameters());
        }
        return false;
    }

    public int hashCode() {
        return this._value.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append(this._value);
        for (int i = 0; i < this._parameters.size(); ++i) {
            Parameter param = this._parameters.get(i);
            sb.append("; ");
            sb.append(param.toString());
        }
        return sb.toString();
    }
}

