/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc3;

import com.sun.net.ssl.internal.ssl.Provider;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.SocketException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import openlink.util.MD5;
import virtuoso.jdbc3.MyX509TrustManager;
import virtuoso.jdbc3.VirtuosoCallableStatement;
import virtuoso.jdbc3.VirtuosoDatabaseMetaData;
import virtuoso.jdbc3.VirtuosoException;
import virtuoso.jdbc3.VirtuosoExplicitString;
import virtuoso.jdbc3.VirtuosoFuture;
import virtuoso.jdbc3.VirtuosoInputStream;
import virtuoso.jdbc3.VirtuosoOutputStream;
import virtuoso.jdbc3.VirtuosoPooledConnection;
import virtuoso.jdbc3.VirtuosoPreparedStatement;
import virtuoso.jdbc3.VirtuosoStatement;
import virtuoso.jdbc3.VirtuosoXAConnection;

public class VirtuosoConnection
implements Connection {
    private Socket socket;
    private VirtuosoInputStream in;
    private VirtuosoOutputStream out;
    private Hashtable futures;
    private int req_no;
    private int con_no;
    private static int global_con_no = 0;
    protected String qualifier;
    private String version;
    private int _case;
    protected openlink.util.Vector client_defaults;
    protected openlink.util.Vector client_charset;
    protected Hashtable client_charset_hash;
    protected SQLWarning warning = null;
    private String peer_name;
    private boolean auto_commit = true;
    private boolean global_transaction = false;
    private String url;
    private String user;
    private String password;
    private String pwdclear;
    private String keystore_pass;
    private String keystore_cert;
    private String keystore_path;
    private String ssl_provider;
    private int trxisolation = 4;
    private boolean readOnly = false;
    protected int timeout_def = 60;
    protected int timeout = 0;
    protected int txn_timeout = 0;
    protected int fbs = 100;
    protected boolean utf8_execs = false;
    protected VirtuosoPooledConnection pooled_connection = null;
    protected VirtuosoXAConnection xa_connection = null;
    protected String charset;
    protected boolean charset_utf8 = false;
    protected Hashtable rdf_type_hash = null;
    protected Hashtable rdf_lang_hash = null;
    protected Hashtable rdf_type_rev = null;
    protected Hashtable rdf_lang_rev = null;
    private Vector hostList = new Vector();
    protected boolean rdf_type_loaded = false;
    protected boolean rdf_lang_loaded = false;
    private boolean useRoundRobin;
    private PreparedStatement pingStatement = null;

    protected Vector parse_vhost(String string, String string2, int n) throws VirtuosoException {
        Vector<VhostRec> vector = new Vector<VhostRec>();
        String string3 = Integer.toString(n);
        String string4 = null;
        StringBuffer stringBuffer = new StringBuffer();
        block4: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case ',': {
                    String string5 = stringBuffer.toString().trim();
                    if (string4 == null) {
                        string4 = string5;
                        string5 = string3;
                    }
                    if (string4 != null && string4.length() > 0) {
                        vector.add(new VhostRec(string4, string5));
                    }
                    string4 = null;
                    stringBuffer.setLength(0);
                    continue block4;
                }
                case ':': {
                    string4 = stringBuffer.toString().trim();
                    stringBuffer.setLength(0);
                    continue block4;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        String string6 = stringBuffer.toString().trim();
        if (string4 == null) {
            string4 = string6;
            string6 = string3;
        }
        if (string4 != null && string4.length() > 0) {
            vector.add(new VhostRec(string4, string6));
        }
        if (vector.size() == 0) {
            vector.add(new VhostRec(string2, n));
        }
        return vector;
    }

    private synchronized int getNextRoundRobinHostIndex() {
        int n = this.hostList.size();
        return (int)(Math.random() * (double)n);
    }

    VirtuosoConnection(String string, String string2, int n, Properties properties) throws VirtuosoException {
        int n2 = 32768;
        int n3 = 32768;
        this.hostList = this.parse_vhost(properties.getProperty("_vhost", ""), string2, n);
        this.req_no = 0;
        this.url = string;
        this.con_no = global_con_no++;
        if (properties.get("charset") != null) {
            this.charset = (String)properties.get("charset");
            if (this.charset.indexOf("UTF-8") != -1) {
                this.charset = null;
                this.charset_utf8 = true;
            }
        }
        this.user = (String)properties.get("user");
        if (this.user == null || this.user.equals("")) {
            this.user = "anonymous";
        }
        this.password = (String)properties.get("password");
        if (this.password == null) {
            this.password = "";
        }
        if (properties.get("timeout") != null) {
            this.timeout = Integer.parseInt(properties.getProperty("timeout"));
        }
        this.pwdclear = (String)properties.get("pwdclear");
        if (properties.get("sendbs") != null) {
            n2 = Integer.parseInt(properties.getProperty("sendbs"));
        }
        if (n2 <= 0) {
            n2 = 32768;
        }
        if (properties.get("recvbs") != null) {
            n3 = Integer.parseInt(properties.getProperty("recvbs"));
        }
        if (n3 <= 0) {
            n3 = 32768;
        }
        if (properties.get("fbs") != null) {
            this.fbs = Integer.parseInt(properties.getProperty("fbs"));
        }
        if (this.fbs <= 0) {
            this.fbs = 100;
        }
        this.keystore_cert = (String)properties.get("certificate");
        this.keystore_pass = (String)properties.get("keystorepass");
        this.keystore_path = (String)properties.get("keystorepath");
        this.ssl_provider = (String)properties.get("provider");
        if (this.pwdclear == null) {
            this.pwdclear = "0";
        }
        this.futures = new Hashtable();
        this.rdf_type_hash = new Hashtable();
        this.rdf_lang_hash = new Hashtable();
        this.rdf_type_rev = new Hashtable();
        this.rdf_lang_rev = new Hashtable();
        this.useRoundRobin = this.getBoolAttr(properties, "roundrobin", false);
        if (this.hostList.size() <= 1) {
            this.useRoundRobin = false;
        }
        this.connect(string2, n, (String)properties.get("database"), n2, n3, properties.get("log_enable") != null ? Integer.parseInt(properties.getProperty("log_enable")) : -1);
        this.pingStatement = this.prepareStatement("select 1");
    }

    public boolean isConnectionLost() {
        try {
            this.pingStatement.setQueryTimeout(1);
            this.pingStatement.execute();
            return false;
        }
        catch (Exception exception) {
            return true;
        }
    }

    protected int getIntAttr(Properties properties, String string, int n) {
        int n2 = n;
        String string2 = properties.getProperty(string);
        try {
            if (string2 != null && string2.length() > 0) {
                n2 = Integer.parseInt(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            n2 = n;
        }
        return n2;
    }

    protected boolean getBoolAttr(Properties properties, String string, boolean bl) {
        boolean bl2 = bl;
        String string2 = properties.getProperty(string);
        if (string2 != null && string2.length() > 0) {
            char c = string2.charAt(0);
            return c == 'Y' || c == 'y' || c == '1';
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void connect(String string, int n, String string2, int n2, int n3, int n4) throws VirtuosoException {
        int n5 = 0;
        int n6 = 0;
        if (this.hostList.size() > 1 && this.useRoundRobin) {
            n6 = n5 = this.getNextRoundRobinHostIndex();
        }
        while (true) {
            try {
                if (this.hostList.size() == 0) {
                    this.connect(string, n, n2, n3);
                    break;
                }
                VhostRec vhostRec = (VhostRec)this.hostList.elementAt(n5);
                this.connect(vhostRec.host, vhostRec.port, n2, n3);
            }
            catch (VirtuosoException virtuosoException) {
                if (virtuosoException.getErrorCode() != -3) {
                    throw virtuosoException;
                }
                ++n5;
                if (this.useRoundRobin) {
                    if (this.hostList.size() == n5) {
                        n5 = 0;
                    }
                    if (n5 != n6) continue;
                    throw virtuosoException;
                }
                if (this.hostList.size() == n5) throw virtuosoException;
                continue;
            }
            break;
        }
        if (string2 != null) {
            new VirtuosoStatement(this).executeQuery("use " + string2);
        }
        if (n4 < 0 || n4 > 3) return;
        new VirtuosoStatement(this).executeQuery("log_enable (" + n4 + ")");
    }

    private long cdef_param(openlink.util.Vector vector, String string, long l) {
        int n = vector != null ? vector.size() : 0;
        for (int i = 0; i < n; i += 2) {
            if (!string.equals((String)vector.elementAt(i))) continue;
            return ((Number)vector.elementAt(i + 1)).longValue();
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect(String string, int n, int n2, int n3) throws VirtuosoException {
        try {
            Object[] objectArray;
            Object object;
            Object object2;
            Object[] objectArray2;
            Object object3;
            if (this.keystore_cert != null) {
                if (this.ssl_provider != null && this.ssl_provider.length() != 0) {
                    Security.addProvider((java.security.Provider)Class.forName(this.ssl_provider).newInstance());
                } else {
                    Security.addProvider((java.security.Provider)new Provider());
                }
                if (this.keystore_cert.length() == 0) {
                    object3 = new MyX509TrustManager();
                    objectArray2 = null;
                    object2 = new TrustManager[]{object3};
                    object = SSLContext.getInstance("TLS");
                    ((SSLContext)object).init((KeyManager[])objectArray2, (TrustManager[])object2, new SecureRandom());
                    objectArray = ((SSLContext)object).getSocketFactory();
                    this.socket = objectArray.createSocket(string, n);
                } else {
                    object3 = KeyManagerFactory.getInstance("SunX509");
                    objectArray2 = SSLContext.getInstance("TLS");
                    object2 = KeyStore.getInstance("JKS");
                    ((KeyStore)object2).load(new FileInputStream(this.keystore_path != null ? this.keystore_path : System.getProperty("user.home") + System.getProperty("file.separator") + ".keystore"), this.keystore_pass != null ? this.keystore_pass.toCharArray() : new String("").toCharArray());
                    ((KeyManagerFactory)object3).init((KeyStore)object2, this.keystore_pass != null ? this.keystore_pass.toCharArray() : new String("").toCharArray());
                    objectArray2.init(((KeyManagerFactory)object3).getKeyManagers(), null, null);
                    this.socket = objectArray2.getSocketFactory().createSocket(string, n);
                }
                ((SSLSocket)this.socket).startHandshake();
            } else {
                this.socket = new Socket(string, n);
            }
            if (this.timeout > 0) {
                this.socket.setSoTimeout(this.timeout * 1000);
            }
            this.socket.setTcpNoDelay(true);
            this.socket.setReceiveBufferSize(n3);
            this.socket.setSendBufferSize(n2);
            this.in = new VirtuosoInputStream(this, this.socket, n3);
            this.out = new VirtuosoOutputStream(this, this.socket, n2);
            object3 = this;
            synchronized (object3) {
                block44: {
                    block43: {
                        int n4;
                        objectArray2 = new Object[]{null};
                        object2 = this.getFuture("caller_identification", objectArray2, this.timeout);
                        object = (openlink.util.Vector)((VirtuosoFuture)object2).nextResult().firstElement();
                        this.peer_name = (String)((openlink.util.Vector)object).elementAt(1);
                        if (((openlink.util.Vector)object).size() > 2) {
                            objectArray = (openlink.util.Vector)((openlink.util.Vector)object).elementAt(2);
                            n4 = (int)this.cdef_param((openlink.util.Vector)objectArray, "SQL_ENCRYPTION_ON_PASSWORD", -1L);
                            switch (n4) {
                                case 1: {
                                    this.pwdclear = "cleartext";
                                    break;
                                }
                                case 2: {
                                    this.pwdclear = "encrypt";
                                    break;
                                }
                                case 0: {
                                    this.pwdclear = "digest";
                                }
                            }
                        }
                        this.removeFuture((VirtuosoFuture)object2);
                        objectArray = new Object[]{this.user, this.pwdclear != null && this.pwdclear.equals("cleartext") ? this.password : (this.pwdclear != null && this.pwdclear.equals("encrypt") ? MD5.pwd_magic_encrypt(this.user, this.password) : MD5.md5_digest(this.user, this.password, this.peer_name)), "06.00.3039"};
                        object2 = this.getFuture("SCON", objectArray, this.timeout);
                        object = ((VirtuosoFuture)object2).nextResult();
                        if (((openlink.util.Vector)object).firstElement() instanceof Short) break block43;
                        object = (openlink.util.Vector)((openlink.util.Vector)object).firstElement();
                        switch (((Number)((openlink.util.Vector)object).firstElement()).shortValue()) {
                            case 9: {
                                this.qualifier = (String)((openlink.util.Vector)object).elementAt(1);
                                this.version = (String)((openlink.util.Vector)object).elementAt(2);
                                n4 = Integer.parseInt(this.version.substring(6));
                                if (n4 < 2303) {
                                    throw new VirtuosoException("Old server version", -17);
                                }
                                this._case = ((Number)((openlink.util.Vector)object).elementAt(3)).intValue();
                                this.client_defaults = ((openlink.util.Vector)object).size() > 3 ? (openlink.util.Vector)((openlink.util.Vector)object).elementAt(4) : null;
                                Object object4 = null;
                                if (((openlink.util.Vector)object).size() > 4) {
                                    object4 = ((openlink.util.Vector)object).elementAt(5);
                                }
                                if (object4 instanceof openlink.util.Vector) {
                                    this.client_charset = (openlink.util.Vector)object4;
                                    String string2 = (String)this.client_charset.elementAt(1);
                                    this.client_charset_hash = new Hashtable(256);
                                    for (int i = 0; i < 255; ++i) {
                                        if (i < string2.length()) {
                                            this.client_charset_hash.put(new Character(string2.charAt(i)), new Byte((byte)(i + 1)));
                                            continue;
                                        }
                                        this.client_charset_hash.put(new Character((char)(i + 1)), new Byte((byte)(i + 1)));
                                    }
                                } else {
                                    this.client_charset = null;
                                }
                                if (this.timeout <= 0) {
                                    this.timeout = (int)(this.cdef_param(this.client_defaults, "SQL_QUERY_TIMEOUT", this.timeout_def * 1000) / 1000L);
                                }
                                if (this.timeout > 0) {
                                    this.socket.setSoTimeout(this.timeout * 1000);
                                }
                                if (this.txn_timeout <= 0) {
                                    this.txn_timeout = (int)(this.cdef_param(this.client_defaults, "SQL_TXN_TIMEOUT", this.txn_timeout * 1000) / 1000L);
                                }
                                if (this.trxisolation <= 0) {
                                    this.trxisolation = (int)this.cdef_param(this.client_defaults, "SQL_TXN_ISOLATION", this.trxisolation);
                                }
                                boolean bl = this.utf8_execs = this.cdef_param(this.client_defaults, "SQL_UTF8_EXECS", 0L) != 0L;
                                if (!this.utf8_execs && this.cdef_param(this.client_defaults, "SQL_NO_CHAR_C_ESCAPE", 0L) != 0L) {
                                    throw new VirtuosoException("Not using UTF-8 encoding of SQL statements, but processing character escapes also disabled", -17);
                                }
                                break block44;
                            }
                            case 3: {
                                this.removeFuture((VirtuosoFuture)object2);
                                throw new VirtuosoException((String)((openlink.util.Vector)object).elementAt(1) + " " + (String)((openlink.util.Vector)object).elementAt(2), -15);
                            }
                            default: {
                                this.removeFuture((VirtuosoFuture)object2);
                                throw new VirtuosoException(((openlink.util.Vector)object).toString(), -16);
                            }
                        }
                    }
                    this.removeFuture((VirtuosoFuture)object2);
                    throw new VirtuosoException("Bad login.", -5);
                }
                this.removeFuture((VirtuosoFuture)object2);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw new VirtuosoException("Class not found: " + noClassDefFoundError.getMessage(), -17);
        }
        catch (IOException iOException) {
            throw new VirtuosoException("Connection failed: " + iOException.getMessage(), -3);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new VirtuosoException("Class not found: " + classNotFoundException.getMessage(), -17);
        }
        catch (InstantiationException instantiationException) {
            throw new VirtuosoException("Class cannot be created: " + instantiationException.getMessage(), -17);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new VirtuosoException("Class cannot be accessed: " + illegalAccessException.getMessage(), -17);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new VirtuosoException("Encryption failed: " + noSuchAlgorithmException.getMessage(), -17);
        }
        catch (KeyStoreException keyStoreException) {
            throw new VirtuosoException("Encryption failed: " + keyStoreException.getMessage(), -17);
        }
        catch (KeyManagementException keyManagementException) {
            throw new VirtuosoException("Encryption failed: " + keyManagementException.getMessage(), -17);
        }
        catch (CertificateException certificateException) {
            throw new VirtuosoException("Encryption failed: " + certificateException.getMessage(), -17);
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            throw new VirtuosoException("Encryption failed: " + unrecoverableKeyException.getMessage(), -17);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write_object(Object object) throws IOException, VirtuosoException {
        if (VirtuosoFuture.rpc_log != null) {
            PrintStream printStream = VirtuosoFuture.rpc_log;
            synchronized (printStream) {
                VirtuosoFuture.rpc_log.print("(conn " + this.hashCode() + ") OUT ");
                VirtuosoFuture.rpc_log.println(object != null ? object.toString() : "<null>");
                VirtuosoFuture.rpc_log.flush();
            }
        }
        try {
            this.out.write_object(object);
            this.out.flush();
        }
        catch (IOException iOException) {
            if (this.pooled_connection != null) {
                VirtuosoException virtuosoException = new VirtuosoException("Connection failed: " + iOException.getMessage(), -3);
                this.pooled_connection.sendErrorEvent(virtuosoException);
                throw virtuosoException;
            }
            throw iOException;
        }
        catch (VirtuosoException virtuosoException) {
            int n;
            if (this.pooled_connection != null && ((n = virtuosoException.getErrorCode()) == -1 || n == -3)) {
                this.pooled_connection.sendErrorEvent(virtuosoException);
            }
            throw virtuosoException;
        }
    }

    protected void write_bytes(byte[] byArray) throws IOException, VirtuosoException {
        try {
            for (int i = 0; i < byArray.length; ++i) {
                this.out.write(byArray[i]);
            }
            this.out.flush();
        }
        catch (IOException iOException) {
            if (this.pooled_connection != null) {
                VirtuosoException virtuosoException = new VirtuosoException("Connection failed: " + iOException.getMessage(), -3);
                this.pooled_connection.sendErrorEvent(virtuosoException);
                throw virtuosoException;
            }
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected VirtuosoFuture getFuture(String string, Object[] objectArray, int n) throws IOException, VirtuosoException {
        int n2;
        VirtuosoFuture virtuosoFuture = null;
        if (this.futures == null) {
            throw new VirtuosoException("Activity on a closed connection", "IM001", -8);
        }
        Hashtable hashtable = this.futures;
        synchronized (hashtable) {
            n2 = this.req_no++;
        }
        virtuosoFuture = new VirtuosoFuture(this, string, objectArray, n2, n);
        this.futures.put(new Integer(n2), virtuosoFuture);
        return virtuosoFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearFutures() {
        if (this.futures != null) {
            Hashtable hashtable = this.futures;
            synchronized (hashtable) {
                this.futures.clear();
            }
        }
    }

    protected void removeFuture(VirtuosoFuture virtuosoFuture) {
        if (this.futures != null) {
            this.futures.remove(new Integer(virtuosoFuture.hashCode()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean read_request() throws IOException, VirtuosoException {
        Object object;
        Object object2;
        if (this.futures == null) {
            throw new VirtuosoException("Activity on a closed connection", "IM001", -8);
        }
        try {
            object2 = this.in.read_object();
        }
        catch (IOException iOException) {
            if (this.pooled_connection != null) {
                VirtuosoException virtuosoException = new VirtuosoException("Connection failed: " + iOException.getMessage(), -3);
                this.pooled_connection.sendErrorEvent(virtuosoException);
                throw virtuosoException;
            }
            throw iOException;
        }
        catch (VirtuosoException virtuosoException) {
            int n;
            if (this.pooled_connection != null && ((n = virtuosoException.getErrorCode()) == -1 || n == -3)) {
                this.pooled_connection.sendErrorEvent(virtuosoException);
            }
            throw virtuosoException;
        }
        if (VirtuosoFuture.rpc_log != null) {
            object = VirtuosoFuture.rpc_log;
            synchronized (object) {
                VirtuosoFuture.rpc_log.print("(conn " + this.hashCode() + ") IN ");
                VirtuosoFuture.rpc_log.println(object2 != null ? object2.toString() : "<null>");
                VirtuosoFuture.rpc_log.flush();
            }
        }
        try {
            object = (openlink.util.Vector)object2;
            Object object3 = ((openlink.util.Vector)object).firstElement();
            if ((Short)object3 != 2 && (Short)object3 != 3) {
                return false;
            }
            VirtuosoFuture virtuosoFuture = (VirtuosoFuture)this.futures.get(new Integer(((Number)((openlink.util.Vector)object).elementAt(1)).intValue()));
            if (virtuosoFuture == null) {
                return false;
            }
            virtuosoFuture.putResult(((openlink.util.Vector)object).elementAt(2));
            virtuosoFuture.complete((Short)object3 == 2);
            return true;
        }
        catch (ClassCastException classCastException) {
            if (VirtuosoFuture.rpc_log != null) {
                PrintStream printStream = VirtuosoFuture.rpc_log;
                synchronized (printStream) {
                    VirtuosoFuture.rpc_log.println("(conn " + this.hashCode() + ") **** runtime2 " + classCastException.getClass().getName() + " in read_request");
                    classCastException.printStackTrace(VirtuosoFuture.rpc_log);
                    VirtuosoFuture.rpc_log.flush();
                }
            }
            throw new Error(classCastException.getClass().getName() + ":" + classCastException.getMessage());
        }
    }

    protected String getURL() {
        return this.url;
    }

    protected String getUserName() {
        return this.user;
    }

    protected String getQualifierName() {
        return this.qualifier;
    }

    protected String getVersion() {
        return this.version;
    }

    protected int getVersionNum() {
        try {
            return new Integer(this.version.substring(6, 10));
        }
        catch (Exception exception) {
            return 1619;
        }
    }

    protected int getCase() {
        return this._case;
    }

    protected int getTimeout() {
        return this.timeout;
    }

    public void clearWarnings() throws VirtuosoException {
        this.warning = null;
    }

    public void close() throws VirtuosoException {
        try {
            if (this.isClosed()) {
                throw new VirtuosoException("The connection is already closed.", -1);
            }
            if (!this.in.isClosed()) {
                this.in.close();
                this.in = null;
            }
            if (!this.out.isClosed()) {
                this.out.close();
                this.out = null;
            }
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
            this.password = null;
            this.url = null;
            this.user = null;
            this.futures = null;
            this.pooled_connection = null;
            this.xa_connection = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void commit() throws VirtuosoException {
        if (this.global_transaction) {
            throw new VirtuosoException("Cannot commit while in global transaction.", -4);
        }
        try {
            Object object;
            Object[] objectArray = new Object[]{new Long(0L), null};
            VirtuosoFuture virtuosoFuture = this.getFuture("TRXC", objectArray, this.timeout);
            openlink.util.Vector vector = virtuosoFuture.nextResult();
            Object object2 = object = vector == null ? null : vector.firstElement();
            if (object instanceof openlink.util.Vector) {
                openlink.util.Vector vector2 = (openlink.util.Vector)object;
                throw new VirtuosoException((String)vector2.elementAt(2), (String)vector2.elementAt(1), -8);
            }
            this.removeFuture(virtuosoFuture);
        }
        catch (IOException iOException) {
            throw new VirtuosoException("Connection failed: " + iOException.getMessage(), -3);
        }
    }

    public Statement createStatement() throws VirtuosoException {
        return this.createStatement(1003, 1007);
    }

    public boolean getAutoCommit() throws VirtuosoException {
        return this.auto_commit;
    }

    public DatabaseMetaData getMetaData() throws VirtuosoException {
        return new VirtuosoDatabaseMetaData(this);
    }

    public SQLWarning getWarnings() throws VirtuosoException {
        return this.warning;
    }

    public void setTransactionIsolation(int n) throws VirtuosoException {
        if (n != 1 && n != 2 && n != 4 && n != 8) {
            throw new VirtuosoException("Bad parameters.", -4);
        }
        this.trxisolation = n;
    }

    public int getTransactionIsolation() throws VirtuosoException {
        return this.trxisolation;
    }

    public boolean isClosed() {
        return this.socket == null || this.in == null || this.in.isClosed() || this.out == null || this.out.isClosed();
    }

    public CallableStatement prepareCall(String string) throws VirtuosoException {
        return this.prepareCall(string, 1003, 1007);
    }

    public PreparedStatement prepareStatement(String string) throws VirtuosoException {
        return this.prepareStatement(string, 1003, 1007);
    }

    public synchronized void rollback() throws VirtuosoException {
        if (this.global_transaction) {
            throw new VirtuosoException("Cannot rollback while in global transaction.", -4);
        }
        try {
            Object object;
            Object[] objectArray = new Object[]{new Long(1L), null};
            VirtuosoFuture virtuosoFuture = this.getFuture("TRXC", objectArray, this.timeout);
            openlink.util.Vector vector = virtuosoFuture.nextResult();
            Object object2 = object = vector == null ? null : vector.firstElement();
            if (object instanceof openlink.util.Vector) {
                openlink.util.Vector vector2 = (openlink.util.Vector)object;
                throw new VirtuosoException((String)vector2.elementAt(2), (String)vector2.elementAt(1), -8);
            }
            if (virtuosoFuture != null) {
                this.removeFuture(virtuosoFuture);
            }
        }
        catch (IOException iOException) {
            throw new VirtuosoException("Connection failed: " + iOException.getMessage(), -3);
        }
    }

    public void setAutoCommit(boolean bl) throws VirtuosoException {
        if (bl && this.global_transaction) {
            throw new VirtuosoException("Cannot set autocommit mode while in global transaction.", -4);
        }
        this.auto_commit = bl;
    }

    public Statement createStatement(int n, int n2) throws VirtuosoException {
        return new VirtuosoStatement(this, n, n2);
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws VirtuosoException {
        return new VirtuosoCallableStatement(this, string, n, n2);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws VirtuosoException {
        return new VirtuosoPreparedStatement(this, string, n, n2);
    }

    public int hashCode() {
        return this.con_no;
    }

    public void finalize() throws Throwable {
        this.close();
    }

    public boolean isReadOnly() throws VirtuosoException {
        return this.readOnly;
    }

    public void setReadOnly(boolean bl) throws VirtuosoException {
        this.readOnly = bl;
    }

    public String nativeSQL(String string) throws VirtuosoException {
        return "";
    }

    public void setCatalog(String string) throws VirtuosoException {
    }

    public String getCatalog() throws VirtuosoException {
        return this.qualifier;
    }

    public Map getTypeMap() throws VirtuosoException {
        return null;
    }

    public void setTypeMap(Map map) throws VirtuosoException {
    }

    protected void setSocketTimeout(int n) throws VirtuosoException {
        try {
            if (n != -1) {
                this.socket.setSoTimeout(n * 1000);
            }
        }
        catch (SocketException socketException) {
            throw new VirtuosoException("Unable to set socket timeout : " + socketException.getMessage(), "S1000", -17);
        }
    }

    protected VirtuosoExplicitString escapeSQL(String string) throws VirtuosoException {
        VirtuosoExplicitString virtuosoExplicitString;
        if (this.charset != null) {
            byte[] byArray = this.charsetBytes(string);
            VirtuosoExplicitString virtuosoExplicitString2 = new VirtuosoExplicitString(byArray, 182);
            return virtuosoExplicitString2;
        }
        if (this.charset_utf8) {
            VirtuosoExplicitString virtuosoExplicitString3 = new VirtuosoExplicitString(string, 182, this);
            return virtuosoExplicitString3;
        }
        if (this.utf8_execs) {
            try {
                byte[] byArray = new String("\n--utf8_execs=yes\n" + string).getBytes("UTF8");
                virtuosoExplicitString = new VirtuosoExplicitString(byArray, 182);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                virtuosoExplicitString = new VirtuosoExplicitString("\n--utf8_execs=yes\n" + string, 182, this);
            }
        } else {
            virtuosoExplicitString = new VirtuosoExplicitString("", 182, null);
            virtuosoExplicitString.cli_wide_to_escaped(string, this.client_charset_hash);
        }
        return virtuosoExplicitString;
    }

    protected VirtuosoExplicitString escapeSQLString(String string) throws VirtuosoException {
        VirtuosoExplicitString virtuosoExplicitString;
        if (this.charset != null) {
            byte[] byArray = this.charsetBytes(string);
            VirtuosoExplicitString virtuosoExplicitString2 = new VirtuosoExplicitString(byArray, 182);
            return virtuosoExplicitString2;
        }
        if (this.utf8_execs) {
            try {
                byte[] byArray = string.getBytes("UTF8");
                virtuosoExplicitString = new VirtuosoExplicitString(byArray, 182);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                virtuosoExplicitString = new VirtuosoExplicitString(string, 182, this);
            }
        } else {
            virtuosoExplicitString = new VirtuosoExplicitString("", 182, null);
            virtuosoExplicitString.cli_wide_to_escaped(string, this.client_charset_hash);
        }
        return virtuosoExplicitString;
    }

    protected byte[] charsetBytes1(String string, String string2, String string3) throws VirtuosoException {
        byte[] byArray = new byte[]{};
        System.err.println("charsetBytes1(" + string2 + " , " + string3);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string.length());
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, string2);
            outputStreamWriter.write(string, 0, string.length());
            outputStreamWriter.flush();
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            byArray = byArray2;
        }
        catch (Exception exception) {
            throw new VirtuosoException("InternationalizationHelper: UnsupportedEncodingException: " + exception, -10);
        }
        return byArray;
    }

    protected byte[] charsetBytes(String string) throws VirtuosoException {
        if (string == null) {
            return null;
        }
        return this.charsetBytes1(string, this.charset, "8859_1");
    }

    protected String uncharsetBytes(String string) throws VirtuosoException {
        if (string == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string.length());
        try {
            int n;
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "8859_1");
            outputStreamWriter.write(string, 0, string.length());
            outputStreamWriter.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(byArray), this.charset));
            StringBuffer stringBuffer = new StringBuffer();
            char[] cArray = new char[4096];
            while (0 < (n = bufferedReader.read(cArray))) {
                stringBuffer.append(cArray, 0, n);
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            throw new VirtuosoException("InternationalizationHelper: UnsupportedEncodingException: " + exception, -10);
        }
    }

    protected void checkHoldability(int n) throws SQLException {
        if (n == 1) {
            throw new VirtuosoException("Unable to hold cursors over commit", "IM001", -7);
        }
        if (n != 2) {
            throw new VirtuosoException("Invalid holdability value", "22023", -4);
        }
    }

    public void setHoldability(int n) throws SQLException {
        this.checkHoldability(n);
    }

    public int getHoldability() throws SQLException {
        return 2;
    }

    public Savepoint setSavepoint() throws SQLException {
        throw new VirtuosoException("Savepoints not supported", "IM001", -7);
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        throw new VirtuosoException("Savepoints not supported", "IM001", -7);
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        throw new VirtuosoException("Savepoints not supported", "IM001", -7);
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new VirtuosoException("Savepoints not supported", "IM001", -7);
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        this.checkHoldability(n3);
        return this.createStatement(n, n2);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        this.checkHoldability(n3);
        return this.prepareStatement(string, n, n2);
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        this.checkHoldability(n3);
        return this.prepareCall(string, n, n2);
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        return this.prepareStatement(string);
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        return this.prepareStatement(string);
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        return this.prepareStatement(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getGlobalTransaction() {
        if (VirtuosoFuture.rpc_log != null) {
            PrintStream printStream = VirtuosoFuture.rpc_log;
            synchronized (printStream) {
                VirtuosoFuture.rpc_log.println("VirtuosoConnection.getGlobalTransaction () (con=" + this.hashCode() + ") :" + this.global_transaction);
                VirtuosoFuture.rpc_log.flush();
            }
        }
        return this.global_transaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setGlobalTransaction(boolean bl) {
        if (VirtuosoFuture.rpc_log != null) {
            PrintStream printStream = VirtuosoFuture.rpc_log;
            synchronized (printStream) {
                VirtuosoFuture.rpc_log.println("VirtuosoConnection.getGlobalTransaction (" + bl + ") (con=" + this.hashCode() + ") :" + this.global_transaction);
                VirtuosoFuture.rpc_log.flush();
            }
        }
        this.global_transaction = bl;
    }

    protected void setWarning(SQLWarning sQLWarning) {
        sQLWarning.setNextWarning(this.warning);
        this.warning = sQLWarning;
    }

    protected VirtuosoException notify_error(Throwable throwable) {
        VirtuosoException virtuosoException;
        if (!(throwable instanceof VirtuosoException)) {
            virtuosoException = new VirtuosoException(throwable.getMessage(), -3);
            virtuosoException.initCause(throwable);
        } else {
            virtuosoException = (VirtuosoException)throwable;
        }
        if (this.pooled_connection != null && VirtuosoConnection.isCriticalError(virtuosoException)) {
            this.pooled_connection.sendErrorEvent(virtuosoException);
        }
        return virtuosoException;
    }

    public static boolean isCriticalError(SQLException sQLException) {
        if (sQLException == null) {
            return false;
        }
        String string = sQLException.getSQLState();
        if (string != null && string.startsWith("08") && string != "08C04" && string != "08C03" && string != "08001" && string != "08003" && string != "08006" && string != "08007") {
            return true;
        }
        int n = sQLException.getErrorCode();
        return n == -1 || n == -3 || n == -5 || n == -9 || n == -13 || n == -14 || n == -15 || n == -16;
    }

    protected class VhostRec {
        protected String host;
        protected int port;

        protected VhostRec(String string, String string2) throws VirtuosoException {
            this.host = string;
            try {
                this.port = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new VirtuosoException("Wrong port number : " + numberFormatException.getMessage(), -11);
            }
        }

        protected VhostRec(String string, int n) throws VirtuosoException {
            this.host = string;
            this.port = n;
        }
    }
}

