/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc2;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.Socket;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.ListIterator;
import openlink.util.Vector;
import openlink.util.VectorOfDouble;
import openlink.util.VectorOfFloat;
import openlink.util.VectorOfLong;
import virtuoso.jdbc2.VirtuosoBlob;
import virtuoso.jdbc2.VirtuosoConnection;
import virtuoso.jdbc2.VirtuosoException;
import virtuoso.jdbc2.VirtuosoExplicitString;
import virtuoso.jdbc2.VirtuosoExtendedString;
import virtuoso.jdbc2.VirtuosoInputStream;
import virtuoso.jdbc2.VirtuosoNullParameter;
import virtuoso.jdbc2.VirtuosoRdfBox;

class VirtuosoOutputStream
extends BufferedOutputStream {
    private VirtuosoConnection connection;
    private byte[] tmp = new byte[16];
    private static final int DefaultBufferSize = 2048;
    static final int[] cumdays_in_month = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};

    VirtuosoOutputStream(VirtuosoConnection virtuosoConnection, OutputStream outputStream) throws IOException {
        this(virtuosoConnection, outputStream, 2048);
    }

    VirtuosoOutputStream(VirtuosoConnection virtuosoConnection, OutputStream outputStream, int n) throws IOException {
        super(outputStream, n);
        this.connection = virtuosoConnection;
    }

    VirtuosoOutputStream(VirtuosoConnection virtuosoConnection, Socket socket) throws IOException {
        this(virtuosoConnection, socket.getOutputStream());
    }

    VirtuosoOutputStream(VirtuosoConnection virtuosoConnection, Socket socket, int n) throws IOException {
        this(virtuosoConnection, socket.getOutputStream(), n);
    }

    protected boolean isClosed() {
        return this.out == null;
    }

    protected void write_object(Object object) throws IOException, VirtuosoException {
        int n = this.whatIs(object);
        switch (n) {
            case 196: {
                LinkedList linkedList = (LinkedList)object;
                int n2 = linkedList.size();
                this.write(193);
                this.writeint(n2);
                ListIterator listIterator = linkedList.listIterator();
                while (listIterator.hasNext()) {
                    this.write_object(listIterator.next());
                }
                return;
            }
            case 193: {
                Vector vector = (Vector)object;
                int n3 = vector.size();
                this.write(n);
                this.writeint(n3);
                int n4 = 0;
                while (n4 < n3) {
                    this.write_object(vector.elementAt(n4));
                    ++n4;
                }
                return;
            }
            case 209: {
                VectorOfLong vectorOfLong = (VectorOfLong)object;
                int n5 = vectorOfLong.size();
                this.write(n);
                this.writeint(n5);
                int n6 = 0;
                while (n6 < n5) {
                    this.writelongint((Long)vectorOfLong.elementAt(n6));
                    ++n6;
                }
                return;
            }
            case 194: {
                Vector vector = (Vector)object;
                int n7 = vector.size();
                this.write(n);
                this.writeint(n7);
                int n8 = 0;
                while (n8 < n7) {
                    this.writeint(((Number)vector.elementAt(n8)).longValue());
                    ++n8;
                }
                return;
            }
            case 195: {
                VectorOfDouble vectorOfDouble = (VectorOfDouble)object;
                int n9 = vectorOfDouble.size();
                this.write(n);
                this.writeint(n9);
                int n10 = 0;
                while (n10 < n9) {
                    this.writerawdouble((Double)vectorOfDouble.elementAt(n10));
                    ++n10;
                }
                return;
            }
            case 202: {
                VectorOfFloat vectorOfFloat = (VectorOfFloat)object;
                int n11 = vectorOfFloat.size();
                this.write(n);
                this.writeint(n11);
                int n12 = 0;
                while (n12 < n11) {
                    this.writerawfloat(((Float)vectorOfFloat.elementAt(n12)).floatValue());
                    ++n12;
                }
                return;
            }
            case 181: 
            case 182: 
            case 183: 
            case 225: 
            case 226: {
                if (object instanceof VirtuosoExplicitString) {
                    ((VirtuosoExplicitString)object).write(this);
                } else {
                    this.writestring((String)object);
                }
                return;
            }
            case 190: {
                this.writefloat(((Float)object).floatValue());
                return;
            }
            case 191: {
                this.writedouble((Double)object);
                return;
            }
            case 180: 
            case 204: {
                this.write(n);
                return;
            }
            case 186: 
            case 187: {
                String string = (String)object;
                this.write(string.getBytes(), 0, string.length());
                return;
            }
            case 188: {
                if (object instanceof Boolean) {
                    this.writeint((Boolean)object == true ? 1L : 0L);
                } else if (object instanceof Byte) {
                    this.writeint(((Byte)object).shortValue());
                } else {
                    this.writeint(((Number)object).shortValue());
                }
                return;
            }
            case 189: {
                this.writeint(((Number)object).longValue());
                return;
            }
            case 247: {
                this.writelong(((Number)object).longValue());
                return;
            }
            case 128: 
            case 129: 
            case 208: 
            case 210: 
            case 211: {
                this.writeDate(object, n);
                return;
            }
            case -1: {
                throw new VirtuosoException("invalid type", -7);
            }
            case 222: {
                byte[] byArray = (byte[])object;
                this.write(222);
                this.write(byArray.length);
                this.write(byArray, 0, byArray.length);
                return;
            }
            case 223: {
                byte[] byArray = (byte[])object;
                this.write(223);
                this.writelongint(byArray.length);
                this.write(byArray, 0, byArray.length);
                return;
            }
            case 131: {
                this.write(126);
                this.writelongint(1L);
                this.writelongint(((VirtuosoBlob)object).hashCode());
                this.writelongint(((VirtuosoBlob)object).length());
                this.writelongint(((VirtuosoBlob)object).key_id);
                this.writelongint(((VirtuosoBlob)object).frag_no);
                this.writelongint(((VirtuosoBlob)object).dir_page);
                this.writelongint(((VirtuosoBlob)object).bh_timestamp);
                this.write_object(((VirtuosoBlob)object).pages);
                return;
            }
            case 125: {
                this.write(126);
                this.writelongint(1L);
                this.writelongint(((VirtuosoBlob)object).hashCode());
                this.writelongint(((VirtuosoBlob)object).length());
                this.writelongint(((VirtuosoBlob)object).key_id);
                this.writelongint(((VirtuosoBlob)object).frag_no);
                this.writelongint(((VirtuosoBlob)object).dir_page);
                this.writelongint(((VirtuosoBlob)object).bh_timestamp);
                this.write_object(((VirtuosoBlob)object).pages);
                return;
            }
            case 219: {
                if (object instanceof Long) {
                    this.writenumeric(BigDecimal.valueOf((Long)object));
                } else {
                    this.writenumeric((BigDecimal)object);
                }
                return;
            }
            case 207: {
                VirtuosoExtendedString virtuosoExtendedString = (VirtuosoExtendedString)object;
                this.write(n);
                this.writelongint(virtuosoExtendedString.strType);
                this.write_object(virtuosoExtendedString.str);
                return;
            }
            case 246: {
                this.writeRdfBox((VirtuosoRdfBox)object);
                return;
            }
        }
        if (!(object instanceof Serializable)) {
            throw new VirtuosoException("Tag " + n + " not defined and the object " + object.getClass().getName() + "is not serializable.", -9);
        }
        this.writeobject(object);
    }

    private void writefloat(float f) throws IOException {
        this.write(190);
        this.writerawfloat(f);
    }

    private void writerawfloat(float f) throws IOException {
        this.writelongint(Float.floatToIntBits(f));
    }

    private void writedouble(double d) throws IOException {
        this.write(191);
        this.writerawdouble(d);
    }

    private void writerawdouble(double d) throws IOException {
        this.writerawlong(Double.doubleToLongBits(d));
    }

    private void writeint(long l) throws IOException {
        if (l >= -128L && l < 128L) {
            this.write(188);
            this.write((byte)l);
        } else {
            this.write(189);
            this.writelongint(l);
        }
    }

    protected void writelongint(long l) throws IOException {
        this.tmp[0] = (byte)(l >> 24 & 0xFFL);
        this.tmp[1] = (byte)(l >> 16 & 0xFFL);
        this.tmp[2] = (byte)(l >> 8 & 0xFFL);
        this.tmp[3] = (byte)(l & 0xFFL);
        this.write(this.tmp, 0, 4);
    }

    protected void writelongint(int n) throws IOException {
        this.tmp[0] = (byte)(n >> 24 & 0xFF);
        this.tmp[1] = (byte)(n >> 16 & 0xFF);
        this.tmp[2] = (byte)(n >> 8 & 0xFF);
        this.tmp[3] = (byte)(n & 0xFF);
        this.write(this.tmp, 0, 4);
    }

    protected void writeshort(short s) throws IOException {
        this.tmp[0] = (byte)(s >> 8 & 0xFF);
        this.tmp[1] = (byte)(s & 0xFF);
        this.write(this.tmp, 0, 2);
    }

    protected void writelong(long l) throws IOException {
        this.write(247);
        this.writerawlong(l);
    }

    protected void writerawlong(long l) throws IOException {
        this.tmp[0] = (byte)(l >> 56 & 0xFFL);
        this.tmp[1] = (byte)(l >> 48 & 0xFFL);
        this.tmp[2] = (byte)(l >> 40 & 0xFFL);
        this.tmp[3] = (byte)(l >> 32 & 0xFFL);
        this.tmp[4] = (byte)(l >> 24 & 0xFFL);
        this.tmp[5] = (byte)(l >> 16 & 0xFFL);
        this.tmp[6] = (byte)(l >> 8 & 0xFFL);
        this.tmp[7] = (byte)(l & 0xFFL);
        this.write(this.tmp, 0, 8);
    }

    private void writenumeric(BigDecimal bigDecimal) throws IOException, VirtuosoException {
        int n;
        String string;
        int n2;
        int n3;
        this.write(219);
        if (bigDecimal.doubleValue() == Double.NaN) {
            this.write(3);
            this.write(8);
            this.write(0);
            this.write(180);
            return;
        }
        if (bigDecimal.doubleValue() == Double.NEGATIVE_INFINITY) {
            this.write(3);
            this.write(17);
            this.write(0);
            this.write(180);
            return;
        }
        if (bigDecimal.doubleValue() == Double.POSITIVE_INFINITY) {
            this.write(3);
            this.write(16);
            this.write(0);
            this.write(180);
            return;
        }
        int n4 = n3 = bigDecimal.signum() == -1 ? 1 : 0;
        if (bigDecimal.signum() == -1) {
            bigDecimal = bigDecimal.negate();
        }
        if ((n2 = (string = bigDecimal.toString()).length()) - 1 > 40) {
            throw new VirtuosoException("Numeric " + string + " too large to transfer to Virtuoso as numeric", -4);
        }
        int n5 = string.indexOf(46);
        int n6 = 0;
        if (n5 < 0) {
            n5 = n2;
        }
        if ((n5 & 1) == 1) {
            n3 |= 4;
        }
        if ((n = n2 - n5 - 1) < 0) {
            n = 0;
        }
        if ((n & 1) == 1) {
            n3 |= 2;
        }
        this.write((n2 + ((n3 & 2) == 2 ? 1 : 0) + ((n3 & 4) == 4 ? 1 : 0) >> 1) + 2);
        this.write(n3);
        this.write(n5 + ((n3 & 4) == 4 ? 1 : 0) >> 1);
        if ((n3 & 4) == 4) {
            this.write(string.charAt(n6++) - 48);
        }
        while (n6 < n5) {
            this.write(string.charAt(n6) - 48 << 4 | string.charAt(n6 + 1) - 48);
            n6 += 2;
        }
        if (n == 0) {
            return;
        }
        ++n6;
        while (n6 <= n + n5 - ((n3 & 2) == 2 ? 1 : 0)) {
            this.write(string.charAt(n6) - 48 << 4 | string.charAt(n6 + 1) - 48);
            n6 += 2;
        }
        if ((n3 & 2) == 2) {
            this.write(string.charAt(n6++) - 48 << 4);
        }
    }

    private void writeRdfBox(VirtuosoRdfBox virtuosoRdfBox) throws IOException, VirtuosoException {
        int n = 0;
        this.write(246);
        if (virtuosoRdfBox.rb_ro_id != 0L) {
            n |= 1;
        }
        if (virtuosoRdfBox.rb_ro_id > 0xFFFFFFFFL) {
            n |= 0x20;
        }
        if (257 != virtuosoRdfBox.rb_lang) {
            n |= 4;
        }
        if (257 != virtuosoRdfBox.rb_type) {
            n |= 8;
        }
        if (virtuosoRdfBox.rb_is_complete) {
            n |= 2;
        }
        this.write(n);
        this.write_object(virtuosoRdfBox.rb_box);
        if (virtuosoRdfBox.rb_ro_id != 0L) {
            if (virtuosoRdfBox.rb_ro_id > 0xFFFFFFFFL) {
                this.writerawlong(virtuosoRdfBox.rb_ro_id);
            } else {
                this.writelongint(virtuosoRdfBox.rb_ro_id);
            }
        }
        if (257 != virtuosoRdfBox.rb_type) {
            this.writeshort(virtuosoRdfBox.rb_type);
        }
        if (257 != virtuosoRdfBox.rb_lang) {
            this.writeshort(virtuosoRdfBox.rb_lang);
        }
    }

    private void writeobject(Object object) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(object);
        objectOutputStream.flush();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        objectOutputStream = null;
        byteArrayOutputStream = null;
        this.write(254);
        this.writelongint(-1);
        if (byArray.length > 255) {
            this.write(223);
            this.writelongint(byArray.length);
        } else {
            this.write(222);
            this.write(byArray.length);
        }
        this.write(byArray, 0, byArray.length);
        byArray = null;
    }

    private void writestring(String string) throws IOException {
        int n = string.length();
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = (byte)string.charAt(n2);
            ++n2;
        }
        if (n < 256) {
            this.write(181);
            this.write(n);
        } else {
            this.write(182);
            this.writelongint(n);
        }
        this.write(byArray, 0, n);
    }

    private void writeDate(Object object, int n) throws IOException {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        java.util.Date date = (java.util.Date)object;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime((java.util.Date)object);
        if (!(object instanceof Time)) {
            int n8 = gregorianCalendar.get(1);
            int n9 = gregorianCalendar.get(2) + 1;
            int n10 = gregorianCalendar.get(5);
            n7 = VirtuosoOutputStream.date2num(n8, n9, n10);
        } else {
            int n11 = 0;
            int n12 = 0;
            int n13 = 0;
            n7 = 0;
        }
        if (!(object instanceof Date)) {
            n6 = gregorianCalendar.get(11);
            n5 = gregorianCalendar.get(12);
            n4 = gregorianCalendar.get(13);
            n3 = object instanceof Timestamp ? ((Timestamp)object).getNanos() : 0;
        } else {
            n3 = 0;
            n4 = 0;
            n5 = 0;
            n6 = 0;
        }
        int n14 = gregorianCalendar.get(15) + gregorianCalendar.get(16);
        if ((n14 /= 60000) != 0) {
            int n15 = n7;
            n2 = 0;
            n2 = VirtuosoInputStream.time_to_sec(0, n6, n5, n4);
            if ((n2 -= 60 * n14) < 0) {
                n15 -= 1 + -n2 / 86400;
                if ((n2 %= 86400) == 0) {
                    ++n15;
                }
                n2 = 86400 + n2;
            } else {
                n15 += n2 / 86400;
                n2 %= 86400;
            }
            int n16 = n2 / 86400;
            n6 = (n2 - n16 * 86400) / 3600;
            n5 = (n2 - n16 * 86400 - n6 * 60 * 60) / 60;
            n4 = n2 % 60;
            n7 = n15;
        }
        this.write(211);
        this.write(n7 >> 16);
        this.write(n7 >> 8);
        this.write(n7);
        this.write(n6);
        n7 = n4;
        this.write(n5 << 2 & 0xFC | n7 >> 4 & 3);
        int n17 = n3;
        this.write(n7 << 4 | n17 >> 16 & 0xF);
        this.write(n17 >> 8);
        this.write(n17);
        if (n14 < 0) {
            n14 = 65536 + n14;
        }
        int[] nArray = new int[]{n14 >> 8, n14 & 0xFF};
        n2 = 1;
        if (object instanceof Time) {
            n2 = 3;
        }
        if (object instanceof Date) {
            n2 = 2;
        }
        nArray[0] = nArray[0] & 7;
        nArray[0] = nArray[0] | n2 << 5;
        this.write(nArray[0]);
        this.write(nArray[1]);
    }

    public static int date2num(int n, int n2, int n3) {
        int n4 = (n - 1) * 365 + (n - 1 >> 2);
        if (n > 1582 || n == 1582 && (n2 > 10 || n2 == 10 && n3 > 14)) {
            n4 -= 10;
        }
        if (n > 1582) {
            n4 += (n - 1) / 400 - 3;
            n4 -= (n - 1) / 100 - 15;
        }
        n4 += cumdays_in_month[n2 - 1];
        n4 += n3;
        if (VirtuosoOutputStream.days_in_february(n) == 29 && n2 > 2) {
            ++n4;
        }
        return n4;
    }

    public static int days_in_february(int n) {
        int n2;
        if (n > 1582) {
            n2 = (n & 3) != 0 ? 28 : (n % 100 == 0 && n % 400 != 0 ? 28 : 29);
        } else {
            if (n == 1582) {
                // empty if block
            }
            int n3 = n2 = (n & 3) != 0 ? 28 : 29;
        }
        if (n == 4) {
            --n2;
        }
        return n2;
    }

    private int whatIs(Object object) {
        if (object == null) {
            return 180;
        }
        if (object instanceof VirtuosoNullParameter) {
            return 204;
        }
        if (object instanceof VectorOfLong) {
            return 209;
        }
        if (object instanceof VectorOfDouble) {
            return 195;
        }
        if (object instanceof VectorOfFloat) {
            return 202;
        }
        if (object instanceof LinkedList) {
            return 196;
        }
        if (object instanceof Vector) {
            return 193;
        }
        if (object instanceof Short) {
            return 188;
        }
        if (object instanceof Boolean) {
            return 188;
        }
        if (object instanceof Byte) {
            return 188;
        }
        if (object instanceof Long) {
            Long l = (Long)object;
            if (l >= -128L && l < 128L) {
                return 188;
            }
            if (l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE) {
                return 189;
            }
            return 247;
        }
        if (object instanceof Integer) {
            Integer n = (Integer)object;
            return n.longValue() >= -128L && n.longValue() < 128L ? 188 : 189;
        }
        if (object instanceof Float) {
            return 190;
        }
        if (object instanceof Double) {
            return 191;
        }
        if (object instanceof String) {
            String string = (String)object;
            return string.length() < 256 ? 181 : 182;
        }
        if (object instanceof BigDecimal) {
            return 219;
        }
        if (object instanceof byte[]) {
            return ((byte[])object).length < 256 ? 222 : 223;
        }
        if (object instanceof Date) {
            return 129;
        }
        if (object instanceof Time) {
            return 210;
        }
        if (object instanceof Timestamp) {
            return 128;
        }
        if (object instanceof java.util.Date) {
            return 211;
        }
        if (object instanceof Clob) {
            return 125;
        }
        if (object instanceof Blob) {
            return 131;
        }
        if (object instanceof VirtuosoExplicitString) {
            VirtuosoExplicitString virtuosoExplicitString = (VirtuosoExplicitString)object;
            return ((VirtuosoExplicitString)object).getDtp();
        }
        if (object instanceof VirtuosoExtendedString) {
            return 207;
        }
        if (object instanceof VirtuosoRdfBox) {
            return 246;
        }
        return 0;
    }
}

