/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2000-2001 by Andreas Zehender
    email                : zehender@kde.org
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#include "pmsolidcolor.h"

#include "pmoutputdevice.h"
#include "pmxmlhelper.h"
#include "pmsolidcoloredit.h"
#include "pmmemento.h"

#include <kdebug.h>
#include "pmglobals.h"

#include <klocale.h>

const PMColor colorDefault = PMColor( 0.0, 0.0, 0.0, 0.0, 0.0 );

PMSolidColor::PMSolidColor( )
      : Base( )
{
   m_color = colorDefault;
}

PMSolidColor::~PMSolidColor( )
{
}

QString PMSolidColor::description( ) const
{
   return i18n( "solid color" );
}

void PMSolidColor::serialize( PMOutputDevice& dev ) const
{
   dev.writeLine( m_color.serialize( true ) );
}

void PMSolidColor::serialize( QDomElement& e, QDomDocument& /*doc*/ ) const
{
   e.setAttribute( "color", m_color.serializeXML( ) );
}

void PMSolidColor::readAttributes( const PMXMLHelper& h )
{
   m_color = h.colorAttribute( "color", colorDefault );
}

bool PMSolidColor::isA( PMObjectType t ) const
{
   if( t == PMTSolidColor )
      return true;
   return Base::isA( t );
}

void PMSolidColor::setColor( const PMColor& c )
{
   if( c != m_color )
   {
      if( m_pMemento )
         m_pMemento->addData( PMTSolidColor, PMColorID, m_color );
      m_color = c;
   }
}

PMDialogEditBase* PMSolidColor::editWidget( QWidget* parent ) const
{
   return new PMSolidColorEdit( parent );
}

void PMSolidColor::restoreMemento( PMMemento* s )
{
   PMMementoDataIterator it( s );
   PMMementoData* data;

   for( ; it.current( ); ++it )
   {
      data = it.current( );
      if( data->objectType( ) == PMTSolidColor )
      {
         switch( data->valueID( ) )
         {
            case PMColorID:
               setColor( data->colorData( ) );
               break;
            default:
               kdError( PMArea ) << "Wrong ID in PMSolidColor::restoreMemento\n";
               break;
         }
      }
   }
   Base::restoreMemento( s );
}
