/***************************************************************************
                            RGBColor.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef RGBCOLOR_H
#define RGBCOLOR_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

 The <code> RGBColor </code> interface is used to represent any <a
 href="http://www.w3.org/TR/REC-CSS2/syndata.-[html value]-def-color">
 RGB color </a> value. This interface reflects the values in the
 underlying style property. Hence, modifications made through this
 interface modify the style property.

 
 @short 
 The <code> RGBColor </code> interface is used to represent any <a
 href="http://www.
*/
@class CSSPrimitiveValue; 
@class QColor; 

@interface  RGBColor : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}
- init;
- copyWithZone: (NSZone *) zone;
- initWithColor: (QColor *)color;
- (void) dealloc;

/** 
 This attribute is used for the red value of the RGB color.

     
*/
- (CSSPrimitiveValue*) red;

/** 
 This attribute is used for the green value of the RGB color.

     
*/
- (CSSPrimitiveValue*) green;

/** 
 This attribute is used for the blue value of the RGB color.

     
*/
- (CSSPrimitiveValue*) blue;
- (QColor*) color;
@end

#endif
