/***************************************************************************
                            PartBase.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef PARTBASE_H
#define PARTBASE_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/KXMLGUIClient.h>

/**

  Base class for all parts.

 @short Base class for all parts.
 
*/

@class KInstance;
@class QObject;

@protocol PartBaseInterface

/**
  Internal method. Called by @ref -[KParts Part]to specify the parent object for plugin objects.

   
*/
- setPartObject: (QObject *)object;
- (QObject*) partObject;

/** 
 Set the instance (@ref KInstance) for this part.

 Call this *first* in the inherited class constructor,
 because it loads the i18n catalogues.
   
*/
- setInstance: (KInstance*)instance;

/** 
 Set the instance (@ref KInstance) for this part.

 Call this *first* in the inherited class constructor,
 because it loads the i18n catalogues.
   
*/
- setInstance: (KInstance*)instance loadPlugins: (BOOL)loadPlugins;
@end

@interface PartBase : KXMLGUIClient <PartBaseInterface>
/**
  Constructor.

*/
- init;

/**
  Destructor.

*/
- (void) dealloc;

@end

#endif
