/***************************************************************************
                            KFloatValidator.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KFLOATVALIDATOR_H
#define KFLOATVALIDATOR_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QValidator.h>

@interface KFloatValidator : QValidator 

/** 
 Constructor.
     
*/
- initWithWidget: (QWidget *)parent name: (NSString *)name;
- initWithWidget: (QWidget *)parent ;

/** 
 Constructor.  Also sets the minimum and maximum values.
     
*/
- initWithDouble: (double)bottom top: (double)top parent: (QWidget *)parent name: (NSString *)name;
- initWithDouble: (double)bottom top: (double)top parent: (QWidget *)parent ;

/** 
 Destructs the validator.
     
*/
- (void) dealloc;

/** 
 Validates the text, and return the result. Does not modify the parameters.
     
*/
- (int) validate: (NSString *)arg1 int: (int)arg2;

/** 
 Fixes the text if possible, providing a valid string. The parameter may be modified.
     
*/
- fixup: (NSString *)arg1;

/** 
 Sets the minimum and maximum value allowed.
     
*/
- setRange: (double)bottom top: (double)top;

/** 
 Returns the current minimum value allowed.
     
*/
- (double) bottom;

/** 
 Returns the current maximum value allowed.
     
*/
- (double) top;

/** 
 Sets the validator to be locale aware if @p is true. In this case, the
 character -[KLocale decimalSymbol] from the global locale is recognized
 as decimal separator.
     
*/
- setAcceptLocalizedNumbers: (BOOL)b;

/** 
 Returns true if the validator is locale aware.

*/
- (BOOL) acceptLocalizedNumbers;
@end

/** Override these methods in subclasses of KFloatValidator to customise event handling behaviour */
@protocol KFloatValidatorEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
