/***************************************************************************
                            KWinModule.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**


 The class KWinModule provides information about the state of the
 window manager as required by windowmanager modules. It informs a
 module about all currently managed windows and changes to them (via
 Qt signals).

 KWinModule uses NETRootInfo internally. Modules written with this
 class will work fine under any window manager that implements the
 NET_WM protocol.

 There are no methods to manipulate windows. Those are defined in
 the classes KWin, NETWinInfo and NETRootInfo.

 See {@link KWinModuleSignals} for signals emitted by KWinModule.

 

 @author Matthias Ettrich (ettrich@kde.org)

 @version $Id: KWinModule.java,v 1.7 2002/11/26 04:17:35 rdale Exp $
 
 @short Base class for KDE Window Manager modules.

*/
public class KWinModule extends QObject  {
	protected KWinModule(Class dummy){super((Class) null);}

	private native void newKWinModule( QObject parent);

/** 
 Creates a KWinModule object and connects to the window
 manager.

*/
	public KWinModule( QObject parent) {
		super((Class) null);
		newKWinModule( parent);
	}
	private native void newKWinModule();
	public KWinModule() {
		super((Class) null);
		newKWinModule();
	}

/** 
 Destructor. Internal cleanup, nothing fancy.

*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Returns the list of all toplevel windows currently managed by the
 window manager in the order of creation. Please do not rely on
 indexes of this list: Whenever you enter Qt's event loop in your
 application, it may happen that entries are removed or added.
 Your module should perhaps work on a copy of this list and verify a
 window with {@link #hasWindow} before any operations.

 Iteration over this list can be done easily with
 <pre>
  QValueList<WId>.ConstIterator it;
  for ( it = module.windows().begin();
        it != modules.windows().end(); ++it ) {
     ... do something here,  (it) is the current WId.
       }
 </pre>

*/
//	public native QValueList<WId>& windows();

/** 
 Returns the list of all toplevel windows currently managed by the
 window manager in the current stacking order (from lower to
 higher). May be useful for pagers.

*/
//	public native QValueList<WId>& stackingOrder();

/** 
 Test to see if <code>id</code> still managed at present.

*/
	public native boolean hasWId( int identifier);

/** 
 Returns a list of the system tray windows.

*/
//	public native QValueList<WId>& systemTrayWindows();

/** 
 Returns the current virtual desktop.

*/
	public native int currentDesktop();

/** 
 Returns the number of virtual desktops.

*/
	public native int numberOfDesktops();

/** 
 Returns the currently active window, or 0 if no window is active.

*/
	public native int activeWindow();

/** 
 Returns the workarea for the specified desktop, or the current
 work area if no desktop has been specified.

*/
	public native QRect workArea( int arg1);

/** 
 Returns the workarea for the specified desktop, or the current
 work area if no desktop has been specified. Excludes struts of
 clients in the exclude List.

*/
//	public native QRect workArea( QValueList<WId>* excludes, int desktop);

/** 
 Returns the name of the specified desktop.

*/
	public native String desktopName( int desktop);

/** 
 Sets the name of the specified desktop.

*/
	public native void setDesktopName( int desktop, String name);

/** 
 Informs kwin via dcop to not manage a window with the
 specified <code>title.</code>

 Useful for swallowing legacy applications, for example java
 applets.

*/
	public native void doNotManage( String title);
}
