/***************************************************************************
                            KKeyChooser.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Configure dictionaries of key/action associations for KAccel and
 KGlobalAccel.

 The class takes care of all aspects of configuration, including
 handling key conflicts internally. Connect to the {@link #allDefault}
 slot if you want to set all configurable shortcuts to their
 default values.

 See {@link KKeyChooserSignals} for signals emitted by KKeyChooser.

 

 @author Nicolas Hadacek <hadacek@via.ecp.fr>
 
 @version $Id: KKeyChooser.java,v 1.9 2002/11/26 04:17:33 rdale Exp $

 @short Widget for configuration of @ref KAccel and @ref KGlobalAccel.

*/
public class KKeyChooser extends QWidget  {
	protected KKeyChooser(Class dummy){super((Class) null);}

	private native void newKKeyChooser( QWidget parent, int type, boolean bAllowLetterShortcuts);

/** 
 Constructor.

*/
	public KKeyChooser( QWidget parent, int type, boolean bAllowLetterShortcuts) {
		super((Class) null);
		newKKeyChooser( parent, type, bAllowLetterShortcuts);
	}
	private native void newKKeyChooser( QWidget parent);
	public KKeyChooser( QWidget parent) {
		super((Class) null);
		newKKeyChooser( parent);
	}
	private native void newKKeyChooser( KActionCollection coll, QWidget parent, boolean bAllowLetterShortcuts);
	public KKeyChooser( KActionCollection coll, QWidget parent, boolean bAllowLetterShortcuts) {
		super((Class) null);
		newKKeyChooser( coll, parent, bAllowLetterShortcuts);
	}
	private native void newKKeyChooser( KActionCollection coll, QWidget parent);
	public KKeyChooser( KActionCollection coll, QWidget parent) {
		super((Class) null);
		newKKeyChooser( coll, parent);
	}
	private native void newKKeyChooser( KAccel actions, QWidget parent, boolean bAllowLetterShortcuts);
	public KKeyChooser( KAccel actions, QWidget parent, boolean bAllowLetterShortcuts) {
		super((Class) null);
		newKKeyChooser( actions, parent, bAllowLetterShortcuts);
	}
	private native void newKKeyChooser( KAccel actions, QWidget parent);
	public KKeyChooser( KAccel actions, QWidget parent) {
		super((Class) null);
		newKKeyChooser( actions, parent);
	}
	private native void newKKeyChooser( KGlobalAccel actions, QWidget parent);
	public KKeyChooser( KGlobalAccel actions, QWidget parent) {
		super((Class) null);
		newKKeyChooser( actions, parent);
	}
//	private native void newKKeyChooser( KShortcutList* arg1, QWidget parent, int type, boolean bAllowLetterShortcuts);
//	public KKeyChooser( KShortcutList* arg1, QWidget parent, int type, boolean bAllowLetterShortcuts) {
//		super((Class) null);
//		newKKeyChooser( arg1, parent, type, bAllowLetterShortcuts);
//	}
//	private native void newKKeyChooser( KShortcutList* arg1, QWidget parent);
//	public KKeyChooser( KShortcutList* arg1, QWidget parent) {
//		super((Class) null);
//		newKKeyChooser( arg1, parent);
//	}
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Insert an action collection, i.e. add all its actions to the ones
 already associated with the KKeyChooser object.
	 
*/
	public native boolean insert( KActionCollection arg1);

/** 
 Insert an action collection, i.e. add all its actions to the ones
 already associated with the KKeyChooser object.

*/
	public native boolean insert( KActionCollection arg1, String title);
	public native void syncToConfig( String sConfigGroup, KConfigBase pConfig, boolean bClearUnset);

/** 
 This function writes any shortcut changes back to the original
 action set(s).
	 
*/
	public native void commitChanges();

/** 
 This commits and then saves the actions to disk.
 Any KActionCollection objects with the xmlFile() value set
 will be written to an xml file.  All other will be written
 to the application's rc file.
	 
*/
	public native void save();
	private native void newKKeyChooser( KAccel actions, QWidget parent, boolean bCheckAgainstStdKeys, boolean bAllowLetterShortcuts, boolean bAllowWinKey);

/** 
 @obsolete
	 
*/
	public KKeyChooser( KAccel actions, QWidget parent, boolean bCheckAgainstStdKeys, boolean bAllowLetterShortcuts, boolean bAllowWinKey) {
		super((Class) null);
		newKKeyChooser( actions, parent, bCheckAgainstStdKeys, bAllowLetterShortcuts, bAllowWinKey);
	}
	private native void newKKeyChooser( KAccel actions, QWidget parent, boolean bCheckAgainstStdKeys, boolean bAllowLetterShortcuts);
	public KKeyChooser( KAccel actions, QWidget parent, boolean bCheckAgainstStdKeys, boolean bAllowLetterShortcuts) {
		super((Class) null);
		newKKeyChooser( actions, parent, bCheckAgainstStdKeys, bAllowLetterShortcuts);
	}
	private native void newKKeyChooser( KGlobalAccel actions, QWidget parent, boolean bCheckAgainstStdKeys, boolean bAllowLetterShortcuts, boolean bAllowWinKey);

/** 
 @obsolete
	 
*/
	public KKeyChooser( KGlobalAccel actions, QWidget parent, boolean bCheckAgainstStdKeys, boolean bAllowLetterShortcuts, boolean bAllowWinKey) {
		super((Class) null);
		newKKeyChooser( actions, parent, bCheckAgainstStdKeys, bAllowLetterShortcuts, bAllowWinKey);
	}
	private native void newKKeyChooser( KGlobalAccel actions, QWidget parent, boolean bCheckAgainstStdKeys, boolean bAllowLetterShortcuts);
	public KKeyChooser( KGlobalAccel actions, QWidget parent, boolean bCheckAgainstStdKeys, boolean bAllowLetterShortcuts) {
		super((Class) null);
		newKKeyChooser( actions, parent, bCheckAgainstStdKeys, bAllowLetterShortcuts);
	}

/** 
 Set all keys to their default values (bindings).

*/
	public native void allDefault();

/** 
 Specifies whether to use the 3 or 4 modifier key scheme.
 This determines which default is used when the 'Default' button is
 clicked.
	 
*/
	public native void setPreferFourModifierKeys( boolean preferFourModifierKeys);

/** 
 Rebuild list entries based on underlying map.
 Use this if you changed the underlying map.
	 
*/
	public native void listSync();
	protected native void initGUI( int type, boolean bAllowLetterShortcuts);
	protected native boolean insert( KAccel arg1);
	protected native boolean insert( KGlobalAccel arg1);
//	protected native boolean insert( KShortcutList* arg1);
	protected native void buildListView( int iList, String title);
	protected native void buildListView( int iList);
	protected native void readGlobalKeys();
	protected native void updateButtons();
	protected native void fontChange( QFont _font);
	protected native void setShortcut( KShortcut cut);
	protected native boolean isKeyPresent( KShortcut cut, boolean warnuser);
	protected native boolean isKeyPresent( KShortcut cut);
//	protected native boolean isKeyPresentLocally( KShortcut cut, KKeyChooserItem ignoreItem, String warnText);
	protected native void _warning( KKeySequence seq, String sAction, String sTitle);
	protected native void virtual_hook( int identifier, int data);
	protected native void slotNoKey();
	protected native void slotDefaultKey();
	protected native void slotCustomKey();
	protected native void slotListItemSelected( QListViewItem item);
	protected native void capturedShortcut( KShortcut cut);
	protected native void slotSettingsChanged( int arg1);
	public static final int Application = 0;
	public static final int ApplicationGlobal = 1;
	public static final int Standard = 2;
	public static final int Global = 3;
	public static final int NoKey = 1;
	public static final int DefaultKey = 0;
	public static final int CustomKey = 1;
}
