/*
    YPS-0.2, NIS-Server for Linux
    Copyright (C) 1994  Tobias Reber

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/*
 *	$Author: root $
 *	$Log: dbmcompat.h,v $
 * Revision 1.4  1994/01/07  00:20:53  root
 * Print error messages for gdbminit
 *
 * Revision 1.3  1994/01/02  20:10:08  root
 * Added GPL notice
 *
 * Revision 1.2  1993/12/30  22:58:15  root
 * *** empty log message ***
 *
 * Revision 1.1  1993/12/30  22:31:17  root
 * Initial revision
 *
 */

#include <gdbm.h>
#define dbminit(dbname) _dbminit(dbname)
#define firstkey() gdbm_firstkey(dataBaseDescriptor)
#define nextkey(key) gdbm_nextkey(dataBaseDescriptor, key)
#define fetch(key) gdbm_fetch(dataBaseDescriptor, key)
#define store(key, val) gdbm_store(dataBaseDescriptor, key, val, GDBM_REPLACE)
#define dbmclose() gdbm_close(dataBaseDescriptor)

extern datum _gdbm_memory;
static GDBM_FILE dataBaseDescriptor;

static inline int
_dbminit(char *n) {
	char *nm=alloca(strlen(n)+5);
	strcpy(nm, n);
	dataBaseDescriptor=gdbm_open(nm, 0,
		(n[strlen(n)-1]=='~')?GDBM_NEWDB:GDBM_READER, 0, NULL);
	if (dataBaseDescriptor==NULL)
		switch(gdbm_errno) {
		case GDBM_NO_ERROR: fprintf(stderr, "GDBM_NO_ERROR\n"); break;
		case GDBM_MALLOC_ERROR: fprintf(stderr, "GDBM_MALLOC_ERROR\n"); break;
		case GDBM_BLOCK_SIZE_ERROR: fprintf(stderr, "GDBM_BLOCK_SIZE_ERROR\n"); break;
		case GDBM_FILE_OPEN_ERROR: fprintf(stderr, "GDBM_FILE_OPEN_ERROR\n"); break;
		case GDBM_FILE_WRITE_ERROR: fprintf(stderr, "GDBM_FILE_WRITE_ERROR\n"); break;
		case GDBM_FILE_SEEK_ERROR: fprintf(stderr, "GDBM_FILE_SEEK_ERROR\n"); break;
		case GDBM_FILE_READ_ERROR: fprintf(stderr, "GDBM_FILE_READ_ERROR\n"); break;
		case GDBM_BAD_MAGIC_NUMBER: fprintf(stderr, "GDBM_BAD_MAGIC_NUMBER\n"); break;
		case GDBM_EMPTY_DATABASE: fprintf(stderr, "GDBM_EMPTY_DATABASE\n"); break;
		case GDBM_CANT_BE_READER: fprintf(stderr, "GDBM_CANT_BE_READER\n"); break;
	        case GDBM_CANT_BE_WRITER: fprintf(stderr, "GDBM_CANT_BE_WRITER\n"); break;
		case GDBM_READER_CANT_DELETE: fprintf(stderr, "GDBM_READER_CANT_DELETE\n"); break;
		case GDBM_READER_CANT_STORE: fprintf(stderr, "GDBM_READER_CANT_STORE\n"); break;
		case GDBM_READER_CANT_REORGANIZE: fprintf(stderr, "GDBM_READER_CANT_REORGANIZE\n"); break;
		case GDBM_UNKNOWN_UPDATE: fprintf(stderr, "GDBM_UNKNOWN_UPDATE\n"); break;
		case GDBM_ITEM_NOT_FOUND: fprintf(stderr, "GDBM_ITEM_NOT_FOUND\n"); break;
		case GDBM_REORGANIZE_FAILED: fprintf(stderr, "GDBM_REORGANIZE_FAILED\n"); break;
		case GDBM_CANNOT_REPLACE: fprintf(stderr, "GDBM_CANNOT_REPLACE\n"); break;
		case GDBM_ILLEGAL_DATA: fprintf(stderr, "GDBM_ILLEGAL_DATA\n"); break;
		}
	return dataBaseDescriptor?0:1;
}
