/***************************************************************************
                          coordinates.h  -  description
                             -------------------
    begin                : Sat May 5 2001
    copyright            : (C) 2001 by
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef COORDINATES_H
#define COORDINATES_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapplication.h>
#include <stdlib.h>
#include <math.h>
#include <qpoint.h>
#include "resource.h"

/**
	* This class models coordinates. It offers different constructors
	* as well as method to move the coordinates or change the corresponding
	* vector to a certain length. You can also get an orthogonal vector.
  *@author
  */

class Coordinates {

	public:

		/** Default constructor */
		Coordinates();
		/** Constructor with x and y value */
		Coordinates( double x, double y );
		/** Constructor with QPoint */
		Coordinates( QPoint pt );
		/** Copy constructor */
    Coordinates( const Coordinates & coords );
		/** Destructor */
		~Coordinates();

		/** Get rounded integer x coordinate. */
		int getI_X();
		/** Get rounded integer y coordinate. */
		int  getI_Y();
		/** Get double precision x coordinate. */
		double getD_X() const;
		/** Get double precision y coordinate. */
		double getD_Y() const;
		/** Get double precision x coordinate, rounded with mant digits. */
		QString getD_X( int mant );
		/** Get double precision y coordinate, rounded with mant digits. */
		QString getD_Y( int mant );
		/** Get coordinates as QPoint object. */
		QPoint getQPoint();
		/** Set double precision x coordinate. */
		void  setX( double x );
		/** Set double precision y coordinate. */
		void  setY( double y );
		/** Set double precision x and y coordinates. */
		void  set( double x, double y );
		/** Set coordinates. */
		void  set( QPoint & pt );
		/** Inverts x coordinate. */
		void  invertX();
		/** Inverts y coordinate. */
		void  invertY();
		/** Move coordinates with this vector. */
		void  move( double x, double y );
		/** Rotates this around coord1 using angle. */
		void  rotate( Coordinates coord1, double angle );
		/** Set vector to length x. */
		void  normalize( double x );
		/** Set vector to length x. */
		void  setLength( double x );
		/** Determines whether *this is on, right or left of line between
        coord1 and coord2. */
		double orientation( Coordinates coord1, Coordinates coord2 );
		/** Get length of vector. */
		double getLength();
		/** Get angle of three points in degrees. */
		double getAngleDeg( Coordinates coord1, Coordinates coord2 );
		/** Get angle of three points in rad. */
		double getAngleRad( Coordinates coord1, Coordinates coord2 );
		/** Get distance of both points of vector. */
		double getDistance( Coordinates coords );
		/** Make this vector orthogonal. */
		void  orthogonalize();
		/** Print out current coordinates to stdout. */
		void  show();
		/** If both, x and y, are >= 0 then the Coordinates are valid, otherwise not. */
		bool	isValid();
		/** Checks, if both Coordinates are horizontal. */
		bool	isHorizontal( Coordinates & coords );
		/** Checks, if both Coordinates are verticalal. */
		bool	isVertical( Coordinates & coords );

		void operator=( Coordinates coords );
		Coordinates operator+( Coordinates coords );
		Coordinates operator-( Coordinates coords );
		Coordinates operator*( double x );
		Coordinates operator/( double x );
		Coordinates operator+=( Coordinates coords );
		Coordinates operator-=( Coordinates coords );
		Coordinates operator*=( double x );
		Coordinates operator/=( double x );

		bool operator==( Coordinates coords );
		bool operator!=( Coordinates coords );

	private:

		int i_x;
		int i_y;
		double d_x;
		double d_y;

		int round( double x );
};

#endif
