/***************************************************************************
                            KWordWrap.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Word-wrap algorithm that takes into account beautifulness ;)
 That means: not letting a letter alone on the last line,
 breaking at punctuation signs, etc.

 Usage: call the static method, {@link formatText}, with the text to
 wrap and the constraining rectangle etc., it will return an instance of KWordWrap
 containing internal data, result of the word-wrapping.
 From that instance you can retrieve the boundingRect, and invoke drawing.

 This design allows to call the word-wrap algorithm only when the text changes
 and not every time we want to know the bounding rect or draw the text.
 
 @short *
 Word-wrap algorithm that takes into account beautifulness ;)
 That means: not letting a letter alone on the last line,
 breaking at punctuation signs, etc.
*/
public class  KWordWrap implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KWordWrap(Class dummy){}


/** 

*/
	public native QRect boundingRect();

/** 

*/
	public native String wrappedString();

/** 

*/
	public native String truncatedString( boolean dots);
	public native String truncatedString();

/** 
 Draw the text that has been previously wrapped, at position x,y.
 Flags are for alignment, e.g. AlignHCenter. Default is AlignAuto.
     
*/
	public native void drawText( QPainter painter, int x, int y, int flags);
	public native void drawText( QPainter painter, int x, int y);

/** 
 Main method for wrapping text.

*/
	public static native KWordWrap formatText( QFontMetrics fm, QRect r, int flags, String str, int len);
	public static native KWordWrap formatText( QFontMetrics fm, QRect r, int flags, String str);
}
