/***************************************************************************
                            KPropertiesDialog.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 The main properties dialog class.
 A Properties Dialog is a dialog which displays various information
 about a particular file or URL, or several ones.
 This main class holds various related classes, which are instantiated in
 the form of tab entries in the tabbed dialog that this class provides.
 The various tabs themselves will let the user view or change information
 about the file or URL.

 This class must be created with (void)new KPropertiesDialog(...)
 It will take care of deleting itself.
 
 See {@link KPropertiesDialogSignals} for signals emitted by KPropertiesDialog.

 

 @short *
 The main properties dialog class.
*/
public class KPropertiesDialog extends KDialogBase  {
	protected KPropertiesDialog(Class dummy){super((Class) null);}

	private native void newKPropertiesDialog( KFileItem item, QWidget parent, String name, boolean modal, boolean autoShow);

/** 
 Brings up a Properties dialog. Normal constructor for
 file-manager-like applications.  Normally you will use this
 method rather than the one below.

*/
	public KPropertiesDialog( KFileItem item, QWidget parent, String name, boolean modal, boolean autoShow) {
		super((Class) null);
		newKPropertiesDialog( item, parent, name, modal, autoShow);
	}
	private native void newKPropertiesDialog( KFileItem item);
	public KPropertiesDialog( KFileItem item) {
		super((Class) null);
		newKPropertiesDialog( item);
	}
	private native void newKPropertiesDialog( ArrayList _items, QWidget parent, String name, boolean modal, boolean autoShow);

/** 
 Brings up a Properties dialog. Normal constructor for
 file-manager-like applications.

*/
	public KPropertiesDialog( ArrayList _items, QWidget parent, String name, boolean modal, boolean autoShow) {
		super((Class) null);
		newKPropertiesDialog( _items, parent, name, modal, autoShow);
	}
	private native void newKPropertiesDialog( ArrayList _items);
	public KPropertiesDialog( ArrayList _items) {
		super((Class) null);
		newKPropertiesDialog( _items);
	}
	private native void newKPropertiesDialog( KURL _url, QWidget parent, String name, boolean modal, boolean autoShow);

/** 

 Brings up a Properties dialog. Convenience constructor for
 non-file-manager applications.

  /
 Brings up a Properties dialog. Convenience constructor for
 non-file-manager applications.

*/
	public KPropertiesDialog( KURL _url, QWidget parent, String name, boolean modal, boolean autoShow) {
		super((Class) null);
		newKPropertiesDialog( _url, parent, name, modal, autoShow);
	}
	private native void newKPropertiesDialog( KURL _url);
	public KPropertiesDialog( KURL _url) {
		super((Class) null);
		newKPropertiesDialog( _url);
	}
	private native void newKPropertiesDialog( KURL _tempUrl, KURL _currentDir, String _defaultName, QWidget parent, String name, boolean modal, boolean autoShow);

/** 
 Creates a properties dialog for a new .desktop file (whose name
 is not known yet), based on a template. Special constructor for
 "File / New" in file-manager applications.

*/
	public KPropertiesDialog( KURL _tempUrl, KURL _currentDir, String _defaultName, QWidget parent, String name, boolean modal, boolean autoShow) {
		super((Class) null);
		newKPropertiesDialog( _tempUrl, _currentDir, _defaultName, parent, name, modal, autoShow);
	}
	private native void newKPropertiesDialog( KURL _tempUrl, KURL _currentDir, String _defaultName);
	public KPropertiesDialog( KURL _tempUrl, KURL _currentDir, String _defaultName) {
		super((Class) null);
		newKPropertiesDialog( _tempUrl, _currentDir, _defaultName);
	}
	private native void newKPropertiesDialog( String title, QWidget parent, String name, boolean modal);

/** 
 Creates an empty properties dialog (for applications that want use
 a standard dialog, but for things not doable via the plugin-mechanism).

*/
	public KPropertiesDialog( String title, QWidget parent, String name, boolean modal) {
		super((Class) null);
		newKPropertiesDialog( title, parent, name, modal);
	}
	private native void newKPropertiesDialog( String title);
	public KPropertiesDialog( String title) {
		super((Class) null);
		newKPropertiesDialog( title);
	}

/** 
 Cleans up the properties dialog and frees any associated resources,
 including the dialog itself. Note that when a properties dialog is
 closed it cleans up and deletes itself.
   
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Adds a "3rd party" properties plugin to the dialog.  Useful
 for extending the properties mechanism.

 To create a new plugin type, inherit from the base class KPropsPlugin
 and implement all the methods. If you define a service .desktop file
 for your plugin, you do not need to call insertPlugin().

*/
	public native void insertPlugin( KPropsDlgPlugin plugin);

/** 

*/
	public native KURL kurl();

/** 

*/
	public native KFileItem item();

/** 

*/
	public native ArrayList items();

/** 

   
*/
	public native KDialogBase dialog();
//	public native KDialogBase dialog();

/** 
 If we are building this dialog from a template,

*/
	public native KURL currentDir();

/** 
 If we are building this dialog from a template,

*/
	public native String defaultName();

/** 
 Updates the item url (either called by rename or because
 a global apps/mimelnk desktop file is being saved)
 Can only be called if the dialog applies to a single file/URL.

*/
	public native void updateUrl( KURL _newUrl);

/** 
 #see FilePropsPlugin.applyChanges
 Can only be called if the dialog applies to a single file/URL.

*/
	public native void rename( String _name);

/** 
 To abort applying changes.
   
*/
	public native void abortApplying();

/** 

*/
	public native void showFileSharingPage();

/** 
 Called when the user presses 'Ok'.
   
*/
	public native void slotOk();
	public native void slotCancel();

/** 

*/
	public static native boolean canDisplay( ArrayList _items);
	protected native void virtual_hook( int identifier, int data);
}
