/***************************************************************************
                            KMacroCommand.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 A Macro Command is a command that holds several sub-commands.
 It will appear as one to the user and in the command history,
 but it can use the implementation of multiple commands internally.
 
 @short *
 A Macro Command is a command that holds several sub-commands.
*/
public class KMacroCommand extends KNamedCommand  {
	protected KMacroCommand(Class dummy){super((Class) null);}

	private native void newKMacroCommand( String name);

/** 
 Creates a macro command. You will then need to call {@link addCommand}
 for each subcommand to be added to this macro command.

*/
	public KMacroCommand( String name) {
		super((Class) null);
		newKMacroCommand( name);
	}
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Appends a command to this macro command.
 The ownership is transfered to the macro command.
     
*/
	public native void addCommand( KCommand command);

/** 
 Executes this command, i.e. execute all the sub-commands
 in the order in which they were added.
     
*/
	public native void execute();

/** 
 Undoes the execution of this command, i.e. #unexecute all the sub-commands
 in the _reverse_ order to the one in which they were added.
     
*/
	public native void unexecute();
	protected native void virtual_hook( int identifier, int data);
}
