/***************************************************************************
                            FMOut.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 FM device output class . FMOut is used to send MIDI events to 
 FM devices, such as AdLib cards, or OPL3 synthesizers.

 FMOut inherits {@link MidiOut} and supports the same simple API.

 The preferred way to use this class is by selecting a FM device
 on the {@link MidiManager} and using a {@link MidiManager} object directly

 @author Antonio Larrosa Jimenez <larrosa@kde.org>
 
 @version 0.9.5 17/01/2000

 @short Sends MIDI events to FM devices.
*/
public class FMOut extends MidiOut  {
	protected FMOut(Class dummy){super((Class) null);}

	private native void newFMOut( int d, int total);

/** 
 Constructor. See {@link MidiOut#MidiOut} for more information.
     
*/
	public FMOut( int d, int total) {
		super((Class) null);
		newFMOut( d, total);
	}
	private native void newFMOut();
	public FMOut() {
		super((Class) null);
		newFMOut();
	}

/** 
 Destructor. 
     
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 See {@link MidiOut#openDev}
     
*/
	public native void openDev( int sqfd);

/** 
 See {@link MidiOut#closeDev}
     
*/
	public native void closeDev();

/** 
 See {@link MidiOut#initDev}
     
*/
	public native void initDev();

/** 
 See {@link MidiOut#noteOn}
     
*/
	public native void noteOn( String chn, String note, String vel);

/** 
 See {@link MidiOut#noteOff}
     
*/
	public native void noteOff( String chn, String note, String vel);

/** 
 See {@link MidiOut#keyPressure}
     
*/
	public native void keyPressure( String chn, String note, String vel);

/** 
 See {@link MidiOut#chnPatchChange}
     
*/
	public native void chnPatchChange( String chn, String patch);

/** 
 See {@link MidiOut#chnPressure}
     
*/
	public native void chnPressure( String chn, String vel);

/** 
 See {@link MidiOut#chnPitchBender}
     
*/
	public native void chnPitchBender( String chn, String lsb, String msb);

/** 
 See {@link MidiOut#chnController}
     
*/
	public native void chnController( String chn, String ctl, String v);

/** 
 It's an empty function, as FM devices don't support System Exclusive
 messages
     
*/
	public native void sysex( String data, long size);

/** 
 See {@link MidiOut#setVolumePercentage}
     
*/
	public native void setVolumePercentage( int i);

/** 
 Returns <code>p</code> if the patch p has been loaded, or another patch (already loaded)
 if <code>p</code> hasn't been loaded. 
     
*/
	public native int patch( int p);

/** 
 Sets the directory where the FM patches are stored, that is, where the
 std.o3, std.sb, drums.o3 and drums.sb files can be found.

 It will store a copy of the parameter, so you should delete the memory
 used by the parameter you passed.
     
*/
	public static native void setFMPatchesDirectory( String dir);
}
