/*
 *  Copyright (C) 2001 Matthew Mueller
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __galeon_state_h
#define __galeon_state_h

#include "galeon.h"

void state_save_window_state (GdkWindow *window, const gchar *name);
void state_load_window_state (GtkWidget *window, const gchar *name, 
			      int defwidth, int defheight);

void state_save_column_widths (GtkWidget *w, const gchar *name);
void state_load_column_widths (GtkWidget *w, const gchar *name);

void state_save_pane_pos (GtkWidget *pane, const gchar *name);
void state_load_pane_pos (GtkWidget *pane, const gchar *name);

#endif /* __galeon_state_h */
