# /etc/csh.login: This file contains login defaults used by csh and tcsh.

# Set up some environment variables:
if ($?prompt) then
	umask 022
	set cdpath = ( /var/spool )
	set notify
	set history = 100
	setenv OPENWINHOME /usr/openwin
        setenv MANPATH /usr/local/man:/usr/man/preformat:/usr/man:/usr/X11R6/man:/usr/openwin/man
	setenv MINICOM "-c on"
	setenv HOSTNAME "`cat /etc/HOSTNAME`"
	setenv LESS "-M"
	setenv LESSOPEN "|lesspipe.sh %s"
	setenv MOZILLA_HOME /usr/lib/netscape
	set path = ( $path /usr/X11R6/bin $OPENWINHOME/bin /usr/games )
endif

# For non-root users, add the current directory to the search path:
if (! "$uid" == "0") set path = ( $path . )

# I had problems with the backspace key installed by 'tset', but you might want
# to try it anyway, instead to the 'setenv term.....' below it.
# eval `tset -sQ "$term"`
# setenv term linux
# if ! $?TERM setenv TERM linux
# Set to "linux" for unknown term type:
if ("$TERM" == "") setenv TERM linux
if ("$TERM" == "unknown") setenv TERM linux

# Set default POSIX locale:
setenv LC_ALL POSIX

# Set the default shell prompt:
set prompt = "%n@%m:%~%# "

# Set up the LS_COLORS environment variable for color ls output:
eval `dircolors -t`

# Notify user of incoming mail.  This can be overridden in the user's
# local startup file (~/.login)
biff y

# Append any additional csh scripts found in /etc/profile.d/:
[ -d /etc/profile.d ]
if ($status == 0) then
        set nonomatch
        foreach file ( /etc/profile.d/*.csh )
                [ -x $file ]
                if ($status == 0) then
                        source $file
                endif
        end
        unset file nonomatch
endif

