/* This file implements the user fields tab for kabs editing look..
 *
 * the KDE addressbook
 * copyright:  (C) Mirko Sucker, 1998, 1999, 2000
 * mail to:    Mirko Sucker <mirko@kde.org>
 * requires:   recent C++-compiler, at least Qt 2.0
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public
 License as published by the Free Software Foundation; either
 version 2 of the License, or (at your option) any later version.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.
 
 You should have received a copy of the GNU Library General Public License
 along with this library; see the file COPYING.LIB.  If not, write to
 the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.
 
 * $Revision: 1.9 $
 */

#include <klocale.h>
#include <qstring.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qmultilineedit.h>
#include <kmessagebox.h>
#include <kdebug.h>
#include <kabapi.h>
#include <qconfigDB.h>
#include "look_edit_tabuser.h"

TabUser::TabUser(KabAPI* api, QWidget *parent)
  : TabBasic(api, parent)
{
  int row=0;
  const QString Texts[] = { // needed to get the translations:
    // i18n("Headline:"),
    i18n("User field 1:"),
    i18n("User field 2:"),
    i18n("User field 3:"),
    i18n("User field 4:")
  };
  const QCString Keys[] = { // the keys in the configuration section:
    // "user_headline",
    "user_1", "user_2", "user_3", "user_4"
  };
  int count;
  // -----
  layout=new QGridLayout(this, 9, 1, 3, 2);
  if(layout==0)
    {
      KMessageBox::sorry
	(this, i18n("Out of memory."),
	 i18n("General failure."));
      ::exit(-1);
    } 
  for(count=0; count<NoOfFields; ++count)
    {
      texts[count]=new QString(Texts[count]);
      keys[count]=new QCString(Keys[count]);
      labels[count]=new QLabel(*texts[count], this);
      layout->addWidget(labels[count], row++, 0);
      mledits[count]=new QMultiLineEdit(this);
      layout->addWidget(mledits[count], row++, 0);
      connect(mledits[count], SIGNAL(textChanged()),
	      SLOT(textChangedSlot()));
    }
  layout->setRowStretch(row, 1);
}

TabUser::~TabUser()
{
  int count;
  // -----
  for(count=0; count<NoOfFields; ++count)
    {
      delete texts[count];
      delete keys[count];
    }
}

void TabUser::storeContents(AddressBook::Entry& entry)
{
  QString *strings[]= {
    &entry.user1, &entry.user2, &entry.user3, &entry.user4
  };
  int count;
  // -----
  for(count=0; count<NoOfFields; ++count)
    {
      *(strings[count])=mledits[count]->text();
    }
}

void TabUser::setContents(const AddressBook::Entry& entry)
{
  // QString headline;
  const QString *strings[]= {
    // &headline,
    &entry.user1, &entry.user2, &entry.user3, &entry.user4
  };
  int count;
  // -----
  for(count=0; count<NoOfFields; ++count)
    {
      mledits[count]->setText(*strings[count]);
    }
}

void TabUser::textChangedSlot()
{
  kdDebug() << "TabUser::textChangedSlot: user field text changed.";
  emit(changed());
}

void TabUser::configure(KabAPI* api)
{
  /* All keys are set in the constructor that fills the arrays. */
  Section *configsection;
  KeyValueMap *configkeys;
  QString text;
  int count;
  // -----  
  if(api!=0)
    {
      configsection=api->addressbook()->configurationSection();
      if(configsection!=0)
	{
	  configkeys=configsection->getKeys();
	  for(count=0; count<NoOfFields; ++count)
	    {
	      text=*texts[count];
	      if(!configkeys->get(*keys[count], text))
		{
		  kdDebug() << "TabUser::configure: missing settings " <<
			     "in configuration section!";
		}
	      labels[count]->setText(text);
	    }
	}
    }
}

      

