/* This file implements the base class for kabs looks.
 *
 * the KDE addressbook
 * copyright:  (C) Mirko Sucker, 1998, 1999, 2000
 * mail to:    Mirko Sucker <mirko@kde.org>
 * requires:   recent C++-compiler, at least Qt 2.0
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public
 License as published by the Free Software Foundation; either
 version 2 of the License, or (at your option) any later version.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.
 
 You should have received a copy of the GNU Library General Public License
 along with this library; see the file COPYING.LIB.  If not, write to
 the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.
 
 * $Revision: 1.6 $
 */

#ifndef LOOK_KABBASIC_H
#define LOOK_KABBASIC_H

// this includes the AddressBook::Entry definition
class KabAPI;

#include <kabapi.h>

/** This is a pure virtual base class that defines the
 *  interface for how to display and change entries of
 *  the KDE addressbook.
 *
 *  This basic widget does not show anything in its client space.
 *  Derive it and implement its look and how the user may edit the
 *  entry.
 *
 *  The repaintEvent() has to paint the whole widget, since repaint()
 *  calls will not delete the widgets background. */
class KABBasicLook : public QWidget
{
  Q_OBJECT
public:
  /** The constructor. */
  KABBasicLook(KabAPI* database, QWidget* parent=0, const char* name=0);
  /** Set the entry. It will be displayed automatically. */
  virtual void setEntry(const AddressBook::Entry&);
  /** Get the current entry. */
  virtual void getEntry(AddressBook::Entry& entry);
signals:
  /** This signal is emitted when the user changed the entry. */
  void entryChanged();
  /** The user acticated the email address displayed. This may happen
      by, for example, clicking on the displayed mailto-URL. */
  void sendEmail(const QString& address);
  /** The user activated one of the displayed HTTP URLs. For example
      by clicking on the displayed homepage address. */
  void browse(const QString& url);
protected:
  /** The displayed entry. */
  AddressBook::Entry current;
  /** Pointer to the database object. */
  KabAPI *db;
};

#endif // LOOK_KABBASIC_H
