/*

    $Id: toplevel.cpp,v 1.1 2000/05/02 21:27:00 bieker Exp $

    Copyright (C) 2000 Hans Petter Bieker <bieker@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <qlayout.h>
#include <qtabwidget.h>

#include <klocale.h>

#include "kfontmanager.h"
#include "kfontexplorer.h"
#include "kfontlist.h"

#include "toplevel.moc"
#include "toplevel.h"

Toplevel::Toplevel(QWidget *parent, const char *name)
  : KCModule(parent, name)
{
  QVBoxLayout *topLayout = new QVBoxLayout(this);

  QTabWidget *tab = new QTabWidget(this);
  topLayout->addWidget(tab);

  manager = new KFontManager(this, "manager");
  connect(manager, SIGNAL(changed()), SLOT(slotChanged()));
  tab->addTab( manager, i18n("KDE Fonts") );
  KFontExplorer *explorer = new KFontExplorer(this, "explorer");
  tab->addTab( explorer, i18n("Font Explorer") );
  KFontList *list = new KFontList(this, "list");
  tab->addTab( list, i18n("Raw X11 Font List") );
}

Toplevel::~Toplevel()
{
}

void Toplevel::slotChanged()
{
  emit changed(true);
}

void Toplevel::defaults()
{
  manager->defaults();
}

void Toplevel::load()
{
  manager->load();
}

void Toplevel::save()
{
  manager->save();
}
