/*
    $Id: kfontmanager.h,v 1.10 2000/05/02 21:27:00 bieker Exp $

    Copyright (C) 1997 Bernd Johannes Wuebben  <wuebben@math.cornell.edu>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef __KFONTMANAGER_H__
#define __KFONTMANAGER_H__

class QPushButton;
class QListBox;
class QLabel;

#include <qwidget.h>
#include <qstrlist.h>

class KFontManager : public QWidget
{
  Q_OBJECT

public:
  KFontManager( QWidget *parent, const char *name );

  void defaults();
  void load();
  void save();

 signals:
  void changed();

protected slots:
 bool writeKDEInstalledFonts();
 bool loadKDEInstalledFonts();
 void display_selected_example(int);
 void display_available_example(int);
 void add_slot();
 void remove_slot();
 void queryFonts();
 void setColors();

protected:
 QPushButton 	*add, *remove;
 QListBox	*availableFontsList;
 QListBox	*selectedFontsList;
 QLabel		*example_label;

 QStrList 	fontList;
};

#endif


