/* This file implements the test for the kabapi. You have to "make check"
 * to build it.
 *
 * the KDE addressbook
 * copyright:  (C) Mirko Sucker, 1998, 1999, 2000
 * mail to:    Mirko Sucker <mirko@kde.org>
 * requires:   recent C++-compiler, at least Qt 2.0
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public
 License as published by the Free Software Foundation; either
 version 2 of the License, or (at your option) any later version.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.
 
 You should have received a copy of the GNU Library General Public License
 along with this library; see the file COPYING.LIB.  If not, write to
 the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.
 
 * $Revision: 1.9 $
 */

#include <qimage.h>
#include <kabapi.h>
#include <iostream.h>
#include <kapp.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kcmdlineargs.h>

static const char *description = 
	I18N_NOOP("Test program");

static const char *version = "v0.0.1";

int main(int argc, char** argv)
{
  // ############################################################################
  KCmdLineArgs::init(argc, argv, "kabapi_test", description, version);

  KApplication app;

  KabAPI api;
  // ----- <test>:
  if(api.init()!=AddressBook::NoError)
    {
      KMessageBox::information
	(0, i18n("Error initializing addressbook API."),
	 i18n("Error"));
      return -1;
    }
  if(api.exec())
    {
      QString name;
      QString text;
      AddressBook::Entry entry;
      KabKey key;
      // -----
      debug("kabapi_test: test accepted.");
      switch(api.getEntry(entry, key))
	{
	case AddressBook::NoError:
	  api.addressbook()->literalName(entry, name, true, false);
	  text="KabAPI test: entry is "+name.utf8();
	  break;
	case AddressBook::NoEntry:
	  text="KabAPI test: no entries.";
	  break;
	default:
	  text="Internal error.";
	}
      KMessageBox::information(0, text, "Selection");
    } else {
      debug("kabapi_test: test rejected.");
    }
  // ----- </test>
  return 0;
  // ############################################################################
}


