/* This file implements kabs toplevel widget..
 *
 * the KDE addressbook
 * copyright:  (C) Mirko Sucker, 1998, 1999, 2000
 * mail to:    Mirko Sucker <mirko@kde.org>
 * requires:   recent C++-compiler, at least Qt 2.0
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public
 License as published by the Free Software Foundation; either
 version 2 of the License, or (at your option) any later version.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.
 
 You should have received a copy of the GNU Library General Public License
 along with this library; see the file COPYING.LIB.  If not, write to
 the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.
 
 * $Revision: 1.12 $
 */

#ifndef KAB_TOPLEVEL_WIDGET_H
#define KAB_TOPLEVEL_WIDGET_H

#include <ktmainwindow.h>

class KabAPI;
class KabKey;
class KABBasicLook;
class KDataNavigator;
class QPopupMenu;
class QTimer;
class QStringList;
class Section;


class TopLevelWidget : public KTMainWindow
{
  Q_OBJECT
public:
  /** The indices of the statusbar parts. */
  enum StatusbarIndex { Text=1, /**< The status text. */
			Number /**< The number of entries. */
  };
  /** This descriptors are used to create the view. */
  enum View { NoView=0,
	      BusinessCard,
	      Editing
  };
  /** The constructor. */
  TopLevelWidget();
protected:
  /** Construct the menubar. */
  void makeMenu();
  /** Construct the toolbar. */
  void makeToolbar();
  /** Construct the statusbar. */
  void makeStatusbar();
  /** Create the interface to the address database. */
  bool initializeInterface();
  /** Create the view. This method reads the latest view
      chosen by the user and restores it if no view is given.
  */
  void createView(View=NoView, bool recreate=false);
  /** The main widget. There are different child classes of
   *  KABBasicLook. */
  KABBasicLook *view;
  /** Stores the currently selected view. */
  View currentView;
  /** The interface to the AddressBook object. */
  KabAPI *api;
  /** A pointer to a key storing the entry currently displayed.
   *  This property is set by the entrySelected method.
   *  @see entrySelected
   */
  KabKey *current;
  /** The pointer to the file menu. */
  QPopupMenu *file;
  /** The pointer to the import menu. */
  QPopupMenu *import;
  /** The pointer to the edit menu. */
  QPopupMenu *edit;
  /** The id of the mail and browse menu items. */
  int idEditMail, idEditBrowse;
  /** The pointer to the view menu. */
  QPopupMenu *menuview;
  /** The IDs of the view status entries. */
  int idViewBC, idViewEdit;
  /** The datanavigator widget. Although it is child of the toolbar,
   *  the pointer to the datanavigator is stored here to be able to
   *  update its contents. */
  KDataNavigator *nav;
  /** Used to reset the status bar. */
  QTimer *timer;
  /** The list containing the status messages to display. */
  QStringList *messages;
  /** If true, the entry needs to be saved before showing another
      one. */
  bool modified;
  /** Signals that the "Quit" button has been selected. */
  bool closingdown;
  /** Edit this entry. */
  bool editCurrentEntry();
  /** Remove this entry. If quiet is true, the entry is removed
      silently even if query-on-delete is set. Use it for deleting
      temporaries. Careful! */
  bool removeCurrentEntry(bool quiet=false);
public slots:
  /** An entry has been selected. */
  void entrySelected(int);
  /** The entries map has changed. Possibly the database, too...*/
  void entriesChanged();
  // The file menu:
  /** Create a new address database. Triggered from the menu. */
  void createNew();
  /** Load the standard database. This is the predefined user database
   *  created on the first start of the program. Note that the user might
   *  configure this filename!. Triggered from the menu. */
  void loadDefaultDatabase();
  /** Load a database file. With kab2, the filename is no more fixed.
   *  Triggered from the menu. */
  void loadDatabaseFile();
  /** Save the database. */
  void save();
  /** Import kab 1 addressbook. This is triggered from the menu. */
  void importKab1Addressbook();
  /** Set the status bar text. */
  void setStatus(const QString&);
  /** Erase it after some time. */
  void statusbarTimeOut();
  /** The business card view has been selected. */
  void selectViewBC();
  /** The editing view has been selected. */
  void selectViewEdit();
  /** Add an entry. */
  void add();  /** Edit an entry. */
  void editEntry();
  /** Remove an entry. */
  void remove();
  /** Send an email. Calls mail(const QString& url). Just for convenience. */
  void mail();
  /** Send an email. */
  void mail(const QString& url);
  /** Browse the homepage. Calls browse(const QString& url). Just for convenience. */
  void browse();
  /** Browse the homepage. */
  void browse(const QString& url);
  /** Enable all messages disabled by the "do not show again" button. */
  void enableAllMessages();
  /** Configure settings local to the file. User field names, for example. */
  void configureFile();
  /** The currently displayed entry has been changed by the user. We
      will store this in a boolean value, and (according to a
      configuration setting) ask the user to save her changes before
      displaying another entry. */
  void entryChangedSlot();
  /** Quit the application. */
  void quit();
  /** About-kab-slot. Overloaded from KTMainWindow. */
  void showAboutApplication(void);
  /** About-KDE-slot. */
  void aboutKDE();
signals:
  /** Called after changes in the database that the AddressBook object
   *  does not recognize.
   */
  void databaseChanged();
};

#endif // KAB_TOPLEVEL_WIDGET_H
