/* 
 *  Copyright (C) 1999 Bernd Gehrmann
 *                     bernd@physik.hu-berlin.de
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the "Artistic License" which comes with this Kit. 
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * Artistic License for more details.
 *
 * You should have received a copy of the Artistic License with 
 * this Kit, in the file named "Artistic".  If not, I'll be glad
 * to provide one.
 */


#ifndef _SEARCHJOB_H_
#define _SEARCHJOB_H_


#include <kio/job.h>

class Site;


class SearchJob : public KIO::Job
{
    Q_OBJECT

public:
    SearchJob(Site *site);
    void query(QString searchtext);

protected slots:
    void gotData(int, const char *data, int len);
	
protected:
    enum { Begin, ResultList, ResultItem, End } state;

    virtual void parseItem(QString item) = 0;
    void feedtest(QString filename);

    Site *m_site;
    QString m_buf;

};

 
#endif 


