#ifndef _kping_h_
#define _kping_h_

#include <qmap.h>

#include <kprocess.h>


class KPing : public QObject {

  Q_OBJECT

public:
  KPing() {}
  ~KPing();

  void start( QString _host );
  void stop();

signals:
  void speed( QString _host, float speed );
  void error( QString host );

protected slots:
  void slotPingOutput(KProcess *, char *, int);
  void slotProcessDead(KProcess *);

protected:
  void processOutput();

private:
  QString host;

  KProcess childProcess;
  QString buf;
};


class KPingPool : public QObject {

  Q_OBJECT

public:
  KPingPool() {}
  ~KPingPool() {}

  void add( QString host );
  void remove( QString host );

signals:
  void speed( QString host, float speed );

protected slots:
  void slotError( QString host );

private:
  QMap<QString, uint> hostMap;
  QMap<QString, KPing*> pingMap;
};


#endif
