/* 
 *  Copyright (C) 1999 Bernd Gehrmann
 *                     bernd@physik.hu-berlin.de
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the "Artistic License" which comes with this Kit. 
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * Artistic License for more details.
 *
 * You should have received a copy of the Artistic License with 
 * this Kit, in the file named "Artistic".  If not, I'll be glad
 * to provide one.
 */

#include <kstddirs.h>

#include "misc.h"
#include "ftpsearch.h"


FtpSiteManager::FtpSiteManager() {
  KGlobal::dirs()->addResourceType("ftp-sites", KStandardDirs::kde_default("data") + "libsearch/ftp-sites/");
  QStringList list = KGlobal::dirs()->findDirs("ftp-sites", "");
  
  for (QStringList::ConstIterator it = list.begin(); it != list.end(); it++) {
    readSites( *it );
  }
}


void FtpSearch::parseItem(QString item) {
  QString host, path, size, date;
  int pos;
  qDebug( "Found: " + item );
  QString raw = removeHTML(item).simplifyWhiteSpace();
  pos = raw.find(' ');
  if (pos == -1)
    return;
  host = raw.left(pos);
  raw.remove(0, pos+1);
  pos = raw.find(' ');
  if (pos == -1)
    return;
  path = raw.left(pos);
  raw.remove(0, pos+1);
  pos = raw.find(' ');
  if (pos == -1)
    return;
  size = raw.left(pos);
  raw.remove(0, pos+1);
  emit foundItem(host, path, size, raw);
}
