/*
* maildrop.h -- Declaration of class KMailDrop.
* Generated by newclass on Sat Nov 29 20:07:45 EST 1997.
*/
#ifndef SSK_MAILDROP_H
#define SSK_MAILDROP_H

#include<qobject.h>
#include<qstring.h>

class KConfigBase;
class KDropCfgDialog;
class QColor;

/**
* Abstract base class for all mailbox monitors.
* @author Sirtaj Singh Kang (taj@kde.org)
* @version $Id: maildrop.h,v 1.1 1999/07/22 18:16:59 tibirna Exp $
*/
class KMailDrop : public QObject
{
	Q_OBJECT

private:
	QString _caption;
	QString _clickCmd;
	QString _newmailCmd;

	bool _colour;
	QColor *_hlColour;
	QColor *_tColour;
	QString _bgTexture;

	int _lastCount;
public:
	static const char *TypeConfigKey;
	static const char *CaptionConfigKey;
	static const char *ClickConfigKey;
	static const char *NewMailConfigKey;
	static const char *UseColourConfigKey;
	static const char *HlColourConfigKey;
	static const char *TColourConfigKey;
	static const char *BgTextureConfigKey;

	/**
	 * KMailDrop Constructor
	 */
	KMailDrop();

	/**
	 * KMailDrop Destructor
	 */
	virtual ~KMailDrop();

	/** 
	 * @return TRUE if the mailbox and its configuration are valid.
	 */
	virtual bool valid() = 0;

	/** 
	 * Number of messages in the mailbox at the last count.
	 * @return The number of messages in the mailbox since last count.
	 */
	int count() {return _lastCount;};

	/** 
	  * Recheck the number of letters in this mailbox. Raises the
	  * changed(int) signal if new mail is found.
	  *
	  * Concrete subclasses MUST reimplement this method.
	 */
	virtual void recheck()=0;

	/** 
	 */
	virtual bool startMonitor()=0;

	/** 
	 */
	virtual bool stopMonitor()=0;

	/** 
	 * Check monitor run status.
	 * @return true if monitor is running.
	 */
	virtual bool running()=0;

	/** 
	* Add a configuration page to the configuration dialog.
	* Each reimplementation should first call the inherited implementation,
	* then call @ref KDropCfgDialog::addConfigPage with a custom
	* @ref KMonitorCfg object.
	 */
	virtual void addConfigPage( KDropCfgDialog * );

	/** 
	 * Returns a newly created KBoxFactory object initialized to
	 * be equivalent to this object (prototype pattern). 
	 *
	 * Deletion of the returned object becomes the responsibility of 
	 * the caller.
	 *
	 * Subclasses should override this to return objects of their
	 * own type.
	 */
	virtual KMailDrop *clone() const = 0;

	/** 
	 * Read box configuration from a config group. Subclasses that
	 * reimplement this should call the overridden method.
	 *
	 * @param cfg	A configuration object with the group already set to
	 * 		the configuration for this box.
	 * @return true if read was successful, false otherwise.
	 */
	virtual bool readConfigGroup( const KConfigBase& cfg );
	
	/** 
	 * Write box configuration to a config group. Subclasses that
	 * reimplement this should call the overridden method.
	 *
	 * @param cfg	A configuration object with the group already set to
	 * 		the configuration for this box.
	 * @return true if read was successful, false otherwise.
	 */
	virtual bool writeConfigGroup( KConfigBase& cfg ) const;

	/** 
	 * Return the type of this monitor, for display and
	 * configuration purposes. Each concrete subclass should return a 
	 * unique identifier.
	 */
	virtual const char *type() const = 0;

	// data that belongs in every monitor

	const QString &caption() const { return _caption; }
	void setCaption( const QString &t ) 
		{ _caption = t; emit configChanged(); }

	const char *clickCmd() const { return _clickCmd; }
	void setClickCmd( const char *t ) 
		{ _clickCmd = t; emit configChanged(); }

	const char *newmailCmd() const { return _newmailCmd; }
	void setNewmailCmd( const char *t ) 
		{ _newmailCmd = t; emit configChanged(); }

	bool colour() const { return _colour; }
	void setColour( bool enabled ) 
		{ _colour = enabled; emit configChanged(); }
		
	const QColor *hlColour() const { return _hlColour; }
	const QColor *tColour() const { return _tColour; }
	const char *bgTexture() const { return _bgTexture.data(); }

	void setHlColour( const QColor& c );
	void setTColour( const QColor& c );
	void setBgTexture( const char *image );

	/** 
	 * This is called by the manager when it wishes to delete
	 * a monitor. Clients should connect to the @ref ::notifyDisconnect
	 * signal and ensure that the monitor is not accessed after
	 * the signal has been received.
	 *
	 * Reimplementations should call this implementation too.
	 */
	virtual void notifyClients();

public slots:
	/**
	* Forcibly set the count to zero;
	*/
	virtual void forceCountZero();

protected slots:

	void setCount( int );

signals:
	/** 
	 * This signal is emitted when the mailbox discovers 
	 * new messages in the maildrop.
	 */
	void changed( int );

	/** 
	 * This is emitted on configuration change, normally
	 * on an updateConfig() but 
	 */
	void configChanged();

	/** 
	 * Clients should connect to this and discontinue use
	 * after it is emitted.
	 */
	void notifyDisconnect();
};

#endif // SSK_MAILDROP_H
