/* -*- C++ -*-
 *
 *   NetstatDlg.h - Dialog for the netstat command
 * 
 *   part of knu: KDE network utilities
 *
 *   Copyright (C) 1999  John Corey
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __NetstatDlg_h__
#define __NetstatDlg_h__

#include <qcheckbox.h>
#include <qlayout.h>
#include <qlistview.h>

#include "CommandDlg.h"

class NetstatDlg: public CommandDlg
{
  Q_OBJECT

public:
  NetstatDlg(QString commandName, 
	  QWidget* parent = NULL, const char* name = NULL);
  virtual ~NetstatDlg();
  
public slots:
  virtual void slotCmdStdout(KProcess *, char *, int);
  virtual void clearOutput();
  virtual void slotProcessDead(KProcess *);
  virtual void slotLauchCommand();

protected:
  bool         buildCommandLine(QString);

  // widgets
  QCheckBox   *netstatCb1, *netstatCb2, *netstatCb3;
//  QLineEdit   *netstatLe2;
  QLabel      *netstatLbl2;
  QFrame      *frame1;
  QListView   *lv;
  QListViewItem *lines[1024];
  int         numberOfLines;

  // layout
  QBoxLayout  *layout3;
  char part_line[1025];
  #define PART_DEFAULT "-..-"

  void processLineOfOutput(QString);
};


class NetstatCfgDlg: public CommandCfgDlg
{
  // Q_OBJECT

public:
  NetstatCfgDlg(const char *tcs, 
	     QWidget* parent = NULL, const char* name = NULL);
  virtual  ~NetstatCfgDlg();

  /**
   *
   */
  virtual QWidget *makeWidget(QWidget* parent, bool makeLayouts = TRUE);
  virtual void deleteConfigWidget();

  /**
   * commit changes to the configfile
   * 
   * @return if the change have been done
   * @see cancelChanges
   */
  virtual bool commitChanges();
  
  /**
   * cancel changes to the configfile
   *
   * @see commitChanges
   */
  virtual void cancelChanges();

  /**
   * This is called just before the OptionDlg is shown
   */
  void readConfig();

protected:

  // The configWidget
  QButtonGroup *cfgBG;
//  QRadioButton *cfgHostBtn, *cfgNslookupBtn;
  QBoxLayout   *cfgLayout2;
};

#endif // __PingDlg_h__

