/* 
 *  Copyright (C) 1999 Bernd Gehrmann
 *                     bernd@physik.hu-berlin.de
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the "Artistic License" which comes with this Kit. 
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * Artistic License for more details.
 *
 * You should have received a copy of the Artistic License with 
 * this Kit, in the file named "Artistic".  If not, I'll be glad
 * to provide one.
 */


#ifndef _TOPLEVEL_H_
#define _TOPLEVEL_H_ 


#include <ktmainwindow.h>
#include <qmainwindow.h>


class QLineEdit;
class QListView;
class ResultView;
class QPushButton;
class QLabel;
class KHTMLWidget;
class SiteManager;


class TopLevel : public KTMainWindow {
  Q_OBJECT

public:
  TopLevel();
  ~TopLevel() {}


protected slots:

  void slotSearch();
  void slotCancel();
  void slotFinished(int id);
  void slotError(int id, int errid, const char* errortext);
  
  void processItem(QString date, QString subject, QString url,
		   QString forum, QString author);
  void urlActivated(QString url);

private:

  QLineEdit *wordsedit;
  QListView *sitebox;
  QPushButton *searchbutton, *cancelbutton;
  ResultView *resultbox;
  //    KHTMLWidget *htmlview;
  QLabel *foundlabel;
  QList<int> jobs;
  SiteManager *man;
  
  void updateButtons();
};
 
#endif 
