/* $Id: dlgConnection.h,v 1.12 1999/11/18 21:28:04 koss Exp $
   $Log: dlgConnection.h,v $
   Revision 1.12  1999/11/18 21:28:04  koss
   Adapted to a new settings policy.
   All settings are kept in class Settings.
   No more passing over / creating QStringLists etc.

   Revision 1.11  1999/11/15 20:14:10  koss
   Search entries moved to dlgSearch.
   Fixed layout again.
   Now we use units in KNumInput and not in separate QLabels.

   Revision 1.10  1999/11/09 18:24:36  koss
   Ported to KDialogBase.
   Fixed layout stuff ( only QListView in dlgDirectories remains ).

   Revision 1.9  1999/10/18 21:49:53  koss
   switched from QStrList to QStringList.
   fixed layout.
   removed getIntFromString() and getStringFromInt().
   getBoolFromString() renamed to stringToBool().
   getStringFromBool() renamed to boolToString().

   Revision 1.8  1999/08/01 15:41:13  corey
   move to KIntNumInput.

   Revision 1.7  1999/05/30 22:19:36  dmuell
   kintlineedit.h -> knumlineedit.h

   Revision 1.6  1999/05/16 16:59:07  koss
   Added more options for connection type

   Revision 1.5  1999/05/11 19:50:45  koss
   added new group for type of connection

   Revision 1.4  1999/05/08 18:17:09  porten
   KIntegerLine -> KIntLineEdit

   Revision 1.3  1999/05/01 09:16:43  koss
   readded search timeout

   Revision 1.2  1999/04/17 10:06:51  koss
   had to include qstrlist.h

   Revision 1.1.1.1  1999/04/04 13:02:47  koss
   Renamed kget to caitoo

   Revision 1.2  1999/03/20 10:40:15  koss
   Merged with my harddisk, from now on I work on the HEAD branch kget.

   Revision 1.1.1.1  1999/02/10 18:16:34  koss
   Imported sources

   Revision 1.1  1999/02/07 17:11:28  matt
   source entered


   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef _DLGCONNECTION_H
#define _DLGCONNECTION_H

#include <qstringlist.h>
#include <qgroupbox.h> 
#include <qwidget.h>
#include <qlabel.h>
#include <qcheckbox.h>
#include <qcombobox.h>

#include <knuminput.h>

class DlgConnection : public QWidget {

  Q_OBJECT

public:

  DlgConnection( QWidget *parent );
  ~DlgConnection() {}

  void applyData();
  void setData();
     
  int type() { return cmb_type->currentItem(); }

private:

  // reconnect settings
  QGroupBox *gb_reconnect;

  QCheckBox *cb_onerror;

  QLabel *lb_after;
  KIntNumInput *le_after;

  QLabel *lb_retries;
  KIntNumInput *le_retries;

  QCheckBox *cb_onbroken;

  QCheckBox *cb_autoresume;

  // timeout settings
  QGroupBox *gb_timeout;

  QLabel *lb_nodata;
  KIntNumInput *le_nodata;

  QLabel *lb_noresume;
  KIntNumInput *le_noresume;
  QLabel *lb_cannot;

  // type settings
  QGroupBox *gb_type;

  QComboBox *cmb_type;

  QLabel *lb_linknum;
  KIntNumInput *le_linknum;
  QCheckBox *cb_offlinemode;

signals:
  void typeChanged( int type );

protected slots:
  void comboActivated( int Index );
 
};

#endif // _DLGCONNECTION_H
