
#ifndef I810DMA_H
#define I810DMA_H

#include "i810lib.h"
#include "i810_init.h"
#include "mm.h"


/* Vertex data does not use these macros.
 */
#define BEGIN_BATCH( imesa, n )						\
   unsigned int outbatch;						\
   volatile char *virt;							\
   if (I810_DEBUG & DEBUG_VERBOSE_RING)					\
      fprintf(stderr, "BEGIN_BATCH(%d) in %s\n", n, __FUNCTION__);	\
   if (imesa->dma_buffer->total - imesa->dma_buffer->used < n*4) {	\
      i810FlushGeneralLocked( imesa );					\
      i810GetGeneralDmaBufferLocked( imesa );				\
   }									\
   outbatch = imesa->dma_buffer->used;					\
   virt = imesa->dma_buffer->address;			


#define OUT_BATCH(val) do {				\
   *(volatile unsigned int *)(virt + outbatch) = val;	\
   if (I810_DEBUG & DEBUG_VERBOSE_RING)			\
      fprintf(stderr, "OUT_BATCH %x: %x\n",		\
              (int)(outbatch/4), (int)(val));		\
   outbatch += 4;					\
} while (0)
   

#define ADVANCE_BATCH() do {					\
   if (I810_DEBUG & DEBUG_VERBOSE_RING)				\
      fprintf(stderr, "ADVANCE_BATCH(%.1f) in %s\n",		\
                  (outbatch - imesa->dma_buffer->used) / 4.0,	\
                  __FUNCTION__);				\
   imesa->dma_buffer->used = outbatch;				\
} while(0)

#define FINISH_PRIM()

#endif
