
/*
 * Mesa 3-D graphics library
 * Version:  3.3
 *
 * Copyright (C) 1999-2000  Brian Paul   All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * BRIAN PAUL BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */


/*
 * Stub functions for GL_ARB_imaging subset
 *
 * Some of the imaging functions (like blending and color tables) are
 * defined elsewhere in Mesa.
 *
 * There's been some initial work on histogram and minmax support done
 * here but there's a lot more to do.  Any volunteers?
 */


#ifdef PC_HEADER
#include "all.h"
#else
#include "glheader.h"
#include "context.h"
#include "imaging.h"
#include "mmath.h"
#include "teximage.h"
#endif



#define WARNING(MSG)  fprintf(stderr,"Mesa warning: GL_ARB_imaging functions not implemented\n")



void _mesa_ConvolutionFilter1D(GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const GLvoid *image)
{
   (void) target;
   (void) internalformat;
   (void) width;
   (void) format;
   (void) type;
   (void) image;
   WARNING("glConvolutionFilter1D");
}

void _mesa_ConvolutionFilter2D(GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *image)
{
   (void) target;
   (void) internalformat;
   (void) width;
   (void) height;
   (void) format;
   (void) type;
   (void) image;
   WARNING("glConvolutionFilter2D");
}

void _mesa_ConvolutionParameterf(GLenum target, GLenum pname, GLfloat params)
{
   (void) target;
   (void) pname;
   (void) params;
   WARNING("glConvolutionParameterf");
}

void _mesa_ConvolutionParameterfv(GLenum target, GLenum pname, const GLfloat *params)
{
   (void) target;
   (void) pname;
   (void) params;
   WARNING("glConvolutionParameterfv");
}

void _mesa_ConvolutionParameteri(GLenum target, GLenum pname, GLint params)
{
   (void) target;
   (void) pname;
   (void) params;
   WARNING("glConvolutionParameteri");
}

void _mesa_ConvolutionParameteriv(GLenum target, GLenum pname, const GLint *params)
{
   (void) target;
   (void) pname;
   (void) params;
   WARNING("glConvolutionParameteriv");
}

void _mesa_CopyConvolutionFilter1D(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width)
{
   (void) target;
   (void) internalformat;
   (void) x;
   (void) y;
   (void) width;
   WARNING("glCopyConvolutionFilter1D");
}

void _mesa_CopyConvolutionFilter2D(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height)
{
   (void) target;
   (void) internalformat;
   (void) x;
   (void) y;
   (void) width;
   (void) height;
   WARNING("glCopyConvolutionFilter2D");
}

void _mesa_GetConvolutionFilter(GLenum target, GLenum format, GLenum type, GLvoid *image)
{
   (void) target;
   (void) format;
   (void) type;
   (void) image;
   WARNING("glGetConvolutionFilter");
}

void _mesa_GetConvolutionParameterfv(GLenum target, GLenum pname, GLfloat *params)
{
   (void) target;
   (void) pname;
   (void) params;
   WARNING("glGetConvolutionParameterfv");
}

void _mesa_GetConvolutionParameteriv(GLenum target, GLenum pname, GLint *params)
{
   (void) target;
   (void) pname;
   (void) params;
   WARNING("glGetConvolutionParameteriv");
}

void _mesa_GetMinmax(GLenum target, GLboolean reset, GLenum format, GLenum types, GLvoid *values)
{
   (void) target;
   (void) reset;
   (void) format;
   (void) types;
   (void) values;
   WARNING("glGetMinmax");
}

void _mesa_GetHistogram(GLenum target, GLboolean reset, GLenum format, GLenum type, GLvoid *values)
{
   GET_CURRENT_CONTEXT(ctx);
   ASSERT_OUTSIDE_BEGIN_END_AND_FLUSH(ctx, "glGetHistogram");

   WARNING("glGetHistogram");

   if (target != GL_HISTOGRAM) {
      gl_error(ctx, GL_INVALID_ENUM, "glGetHistogram(target)");
      return;
   }

   if (format != GL_RED &&
       format != GL_GREEN &&
       format != GL_BLUE &&
       format != GL_ALPHA &&
       format != GL_RGB &&
       format != GL_RGBA &&
       format != GL_ABGR_EXT &&
       format != GL_LUMINANCE &&
       format != GL_LUMINANCE_ALPHA) {
      gl_error(ctx, GL_INVALID_ENUM, "glGetHistogram(format)");
      return;
   }

   if (type != GL_UNSIGNED_BYTE &&
       type != GL_BYTE &&
       type != GL_UNSIGNED_SHORT &&
       type != GL_SHORT &&
       type != GL_UNSIGNED_INT &&
       type != GL_INT &&
       type != GL_FLOAT) {
      gl_error(ctx, GL_INVALID_ENUM, "glGetHistogram(type)");
      return;
   }

   /* XXX return values */


   if (reset) {
      GLuint i;
      for (i = 0; i < HISTOGRAM_TABLE_SIZE; i++) {
         ctx->Histogram.Count[i][0] = 0;
         ctx->Histogram.Count[i][1] = 0;
         ctx->Histogram.Count[i][2] = 0;
         ctx->Histogram.Count[i][3] = 0;
      }
   }
}


void
_mesa_GetHistogramParameterfv(GLenum target, GLenum pname, GLfloat *params)
{
   GET_CURRENT_CONTEXT(ctx);
   ASSERT_OUTSIDE_BEGIN_END_AND_FLUSH(ctx, "glGetHistogramParameterfv");

   if (target != GL_HISTOGRAM && target != GL_PROXY_HISTOGRAM) {
      gl_error(ctx, GL_INVALID_ENUM, "glGetHistogramParameterfv(target)");
      return;
   }

   switch (pname) {
      case GL_HISTOGRAM_WIDTH:
         *params = (GLfloat) ctx->Histogram.Width;
         break;
      case GL_HISTOGRAM_FORMAT:
         *params = (GLfloat) ctx->Histogram.Format;
         break;
      case GL_HISTOGRAM_RED_SIZE:
         *params = (GLfloat) ctx->Histogram.RedSize;
         break;
      case GL_HISTOGRAM_GREEN_SIZE:
         *params = (GLfloat) ctx->Histogram.GreenSize;
         break;
      case GL_HISTOGRAM_BLUE_SIZE:
         *params = (GLfloat) ctx->Histogram.BlueSize;
         break;
      case GL_HISTOGRAM_ALPHA_SIZE:
         *params = (GLfloat) ctx->Histogram.AlphaSize;
         break;
      case GL_HISTOGRAM_LUMINANCE_SIZE:
         *params = (GLfloat) ctx->Histogram.LuminanceSize;
         break;
      case GL_HISTOGRAM_SINK:
         *params = (GLfloat) ctx->Histogram.Sink;
         break;
      default:
         gl_error(ctx, GL_INVALID_ENUM, "glGetHistogramParameterfv(pname)");
   }
}


void
_mesa_GetHistogramParameteriv(GLenum target, GLenum pname, GLint *params)
{
   GET_CURRENT_CONTEXT(ctx);
   ASSERT_OUTSIDE_BEGIN_END_AND_FLUSH(ctx, "glGetHistogramParameteriv");

   if (target != GL_HISTOGRAM && target != GL_PROXY_HISTOGRAM) {
      gl_error(ctx, GL_INVALID_ENUM, "glGetHistogramParameteriv(target)");
      return;
   }

   switch (pname) {
      case GL_HISTOGRAM_WIDTH:
         *params = (GLint) ctx->Histogram.Width;
         break;
      case GL_HISTOGRAM_FORMAT:
         *params = (GLint) ctx->Histogram.Format;
         break;
      case GL_HISTOGRAM_RED_SIZE:
         *params = (GLint) ctx->Histogram.RedSize;
         break;
      case GL_HISTOGRAM_GREEN_SIZE:
         *params = (GLint) ctx->Histogram.GreenSize;
         break;
      case GL_HISTOGRAM_BLUE_SIZE:
         *params = (GLint) ctx->Histogram.BlueSize;
         break;
      case GL_HISTOGRAM_ALPHA_SIZE:
         *params = (GLint) ctx->Histogram.AlphaSize;
         break;
      case GL_HISTOGRAM_LUMINANCE_SIZE:
         *params = (GLint) ctx->Histogram.LuminanceSize;
         break;
      case GL_HISTOGRAM_SINK:
         *params = (GLint) ctx->Histogram.Sink;
         break;
      default:
         gl_error(ctx, GL_INVALID_ENUM, "glGetHistogramParameteriv(pname)");
   }
}


void
_mesa_GetMinmaxParameterfv(GLenum target, GLenum pname, GLfloat *params)
{
   GET_CURRENT_CONTEXT(ctx);
   ASSERT_OUTSIDE_BEGIN_END_AND_FLUSH(ctx, "glGetMinmaxParameterfv");

   if (target != GL_MINMAX) {
      gl_error(ctx, GL_INVALID_ENUM, "glGetMinmaxParameterfv(target)");
      return;
   }
   if (pname == GL_MINMAX_FORMAT) {
      *params = (GLfloat) ctx->MinMax.Format;
   }
   else if (pname == GL_MINMAX_SINK) {
      *params = (GLfloat) ctx->MinMax.Sink;
   }
   else {
      gl_error(ctx, GL_INVALID_ENUM, "glGetMinMaxParameterfv(pname)");
   }
}


void
_mesa_GetMinmaxParameteriv(GLenum target, GLenum pname, GLint *params)
{
   GET_CURRENT_CONTEXT(ctx);
   ASSERT_OUTSIDE_BEGIN_END_AND_FLUSH(ctx, "glGetMinmaxParameteriv");

   if (target != GL_MINMAX) {
      gl_error(ctx, GL_INVALID_ENUM, "glGetMinmaxParameteriv(target)");
      return;
   }
   if (pname == GL_MINMAX_FORMAT) {
      *params = (GLint) ctx->MinMax.Format;
   }
   else if (pname == GL_MINMAX_SINK) {
      *params = (GLint) ctx->MinMax.Sink;
   }
   else {
      gl_error(ctx, GL_INVALID_ENUM, "glGetMinMaxParameteriv(pname)");
   }
}


void _mesa_GetSeparableFilter(GLenum target, GLenum format, GLenum type, GLvoid *row, GLvoid *column, GLvoid *span)
{
   (void) target;
   (void) format;
   (void) type;
   (void) row;
   (void) column;
   (void) span;
   WARNING("glGetSeperableFilter");
}


void
_mesa_Histogram(GLenum target, GLsizei width, GLenum internalFormat, GLboolean sink)
{
   GLuint i;
   GLboolean error = GL_FALSE;
   GET_CURRENT_CONTEXT(ctx);
   ASSERT_OUTSIDE_BEGIN_END_AND_FLUSH(ctx, "glHistogram");

   WARNING("glHistogram");
   return;

   if (target != GL_HISTOGRAM && target != GL_PROXY_HISTOGRAM) {
      gl_error(ctx, GL_INVALID_ENUM, "glHistogram(target)");
      return;
   }

   if (width < 0 || width > HISTOGRAM_TABLE_SIZE) {
      if (target == GL_PROXY_HISTOGRAM) {
         error = GL_TRUE;
      }
      else {
         if (width < 0)
            gl_error(ctx, GL_INVALID_VALUE, "glHistogram(width)");
         else
            gl_error(ctx, GL_TABLE_TOO_LARGE, "glHistogram(width)");
         return;
      }
   }

   if (width != 0 && _mesa_bitcount(width) != 1) {
      if (target == GL_PROXY_HISTOGRAM) {
         error = GL_TRUE;
      }
      else {
         gl_error(ctx, GL_INVALID_VALUE, "glHistogram(width)");
         return;
      }
   }

   if (_mesa_base_tex_format(internalFormat) < 0 ||
       internalFormat == 1 ||
       internalFormat == 2 ||
       internalFormat == 3 ||
       internalFormat == 4 ||
       internalFormat == GL_INTENSITY ||
       internalFormat == GL_INTENSITY4 ||
       internalFormat == GL_INTENSITY8 ||
       internalFormat == GL_INTENSITY12 ||
       internalFormat == GL_INTENSITY16) {
      if (target == GL_PROXY_HISTOGRAM) {
         error = GL_TRUE;
      }
      else {
         gl_error(ctx, GL_INVALID_ENUM, "glHistogram(internalFormat)");
         return;
      }
   }

   /* reset histograms */
   for (i = 0; i < HISTOGRAM_TABLE_SIZE; i++) {
      ctx->Histogram.Count[i][0] = 0;
      ctx->Histogram.Count[i][1] = 0;
      ctx->Histogram.Count[i][2] = 0;
      ctx->Histogram.Count[i][3] = 0;
   }

   if (error) {
      ctx->Histogram.Width = 0;
      ctx->Histogram.Format = 0;
      ctx->Histogram.RedSize       = 0;
      ctx->Histogram.GreenSize     = 0;
      ctx->Histogram.BlueSize      = 0;
      ctx->Histogram.AlphaSize     = 0;
      ctx->Histogram.LuminanceSize = 0;
   }
   else {
      ctx->Histogram.Width = width;
      ctx->Histogram.Format = internalFormat;
      ctx->Histogram.Sink = sink;
      ctx->Histogram.RedSize       = 0xffffffff;
      ctx->Histogram.GreenSize     = 0xffffffff;
      ctx->Histogram.BlueSize      = 0xffffffff;
      ctx->Histogram.AlphaSize     = 0xffffffff;
      ctx->Histogram.LuminanceSize = 0xffffffff;
   }
}


void
_mesa_Minmax(GLenum target, GLenum internalFormat, GLboolean sink)
{
   GET_CURRENT_CONTEXT(ctx);
   ASSERT_OUTSIDE_BEGIN_END_AND_FLUSH(ctx, "glMinmax");

   if (target != GL_MINMAX) {
      gl_error(ctx, GL_INVALID_ENUM, "glMinMax(target)");
      return;
   }

   if (_mesa_base_tex_format(internalFormat) < 0 ||
       internalFormat == 1 ||
       internalFormat == 2 ||
       internalFormat == 3 ||
       internalFormat == 4 ||
       internalFormat == GL_INTENSITY ||
       internalFormat == GL_INTENSITY4 ||
       internalFormat == GL_INTENSITY8 ||
       internalFormat == GL_INTENSITY12 ||
       internalFormat == GL_INTENSITY16) {
      gl_error(ctx, GL_INVALID_ENUM, "glMinMax(internalFormat)");
      return;
   }

   ctx->MinMax.Sink = sink;
}


void
_mesa_ResetHistogram(GLenum target)
{
   GLuint i;
   GET_CURRENT_CONTEXT(ctx);
   ASSERT_OUTSIDE_BEGIN_END_AND_FLUSH(ctx, "glResetHistogram");

   WARNING("glResetHistogram");

   if (target != GL_HISTOGRAM) {
      gl_error(ctx, GL_INVALID_ENUM, "glResetHistogram(target)");
      return;
   }

   for (i = 0; i < HISTOGRAM_TABLE_SIZE; i++) {
      ctx->Histogram.Count[i][0] = 0;
      ctx->Histogram.Count[i][1] = 0;
      ctx->Histogram.Count[i][2] = 0;
      ctx->Histogram.Count[i][3] = 0;
   }
}


void
_mesa_ResetMinmax(GLenum target)
{
   GET_CURRENT_CONTEXT(ctx);
   ASSERT_OUTSIDE_BEGIN_END_AND_FLUSH(ctx, "glResetMinmax");

   WARNING("glResetMinmax");

   if (target != GL_MINMAX) {
      gl_error(ctx, GL_INVALID_ENUM, "glResetMinMax(target)");
      return;
   }

   ctx->MinMax.Min[RCOMP] = 1000;    ctx->MinMax.Max[RCOMP] = -1000;
   ctx->MinMax.Min[GCOMP] = 1000;    ctx->MinMax.Max[GCOMP] = -1000;
   ctx->MinMax.Min[BCOMP] = 1000;    ctx->MinMax.Max[BCOMP] = -1000;
   ctx->MinMax.Min[ACOMP] = 1000;    ctx->MinMax.Max[ACOMP] = -1000;
}


void
_mesa_SeparableFilter2D(GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *row, const GLvoid *column)
{
   (void) target;
   (void) internalformat;
   (void) width;
   (void) height;
   (void) format;
   (void) type;
   (void) row;
   (void) column;
   WARNING("glSeparableFilter2D");
}


/*
 * Update the min/max values from an array of fragment colors.
 */
void
_mesa_update_minmax(GLcontext *ctx, GLuint n, const GLfloat rgba[][4])
{
   GLuint i;
   for (i = 0; i < n; i++) {
      /* update mins */
      if (rgba[i][RCOMP] < ctx->MinMax.Min[RCOMP])
         ctx->MinMax.Min[RCOMP] = rgba[i][RCOMP];
      if (rgba[i][GCOMP] < ctx->MinMax.Min[GCOMP])
         ctx->MinMax.Min[GCOMP] = rgba[i][GCOMP];
      if (rgba[i][BCOMP] < ctx->MinMax.Min[BCOMP])
         ctx->MinMax.Min[BCOMP] = rgba[i][BCOMP];
      if (rgba[i][ACOMP] < ctx->MinMax.Min[ACOMP])
         ctx->MinMax.Min[ACOMP] = rgba[i][ACOMP];

      /* update maxs */
      if (rgba[i][RCOMP] > ctx->MinMax.Max[RCOMP])
         ctx->MinMax.Max[RCOMP] = rgba[i][RCOMP];
      if (rgba[i][GCOMP] < ctx->MinMax.Max[GCOMP])
         ctx->MinMax.Max[GCOMP] = rgba[i][GCOMP];
      if (rgba[i][BCOMP] < ctx->MinMax.Max[BCOMP])
         ctx->MinMax.Max[BCOMP] = rgba[i][BCOMP];
      if (rgba[i][ACOMP] < ctx->MinMax.Max[ACOMP])
         ctx->MinMax.Max[ACOMP] = rgba[i][ACOMP];
   }
}


/*
 * Update the histogram values from an array of fragment colors.
 */
void
_mesa_update_histogram(GLcontext *ctx, GLuint n, const GLchan rgba[][4])
{
   GLuint i;
   switch (ctx->Histogram.Format) {
      case GL_RGBA:
         for (i = 0; i < n; i++) {
            GLubyte r = rgba[i][RCOMP];
            GLubyte g = rgba[i][GCOMP];
            GLubyte b = rgba[i][BCOMP];
            GLubyte a = rgba[i][ACOMP];
            ctx->Histogram.Count[r][RCOMP]++;
            ctx->Histogram.Count[g][RCOMP]++;
            ctx->Histogram.Count[b][RCOMP]++;
            ctx->Histogram.Count[a][RCOMP]++;
         }
         break;
      default:
         gl_problem(ctx, "Bad format in _mesa_update_histogram()");
   }
}
