/*
 *  desktop -- The 3dfx Desktop Demo 
 *  COPYRIGHT 3DFX INTERACTIVE, INC. 1999
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef CONTROL_H
#define CONTROL_H

#include "global.h"

enum Background_Mode
{
  BG_TILED,
  BG_SCALED
};
typedef enum Background_Mode Background_Mode;

typedef struct
{
  /* The demo state */
  Demo_State *state;
  
  Display *display;
  //Display *other_display;

  Window window;
  Window background, quit, thumb;
  Window tiled;
  Window thumbs[NTHUMBS];
  Window amp_grip, amp_slot, amp_left, amp_right;
  Window logo, tux;

  /* Radio button state */
  Background_Mode bmode;

  /* The pixmaps for thumbnail images */
  Pixmap thumb_pix[NTHUMBS];
  Pixmap bg_pix[BACK_LAST];
  Pixmap scaled_pix;
  Pixmap tiled_pix;
  Pixmap logo_pix;
  Pixmap tux_pix;
  Pixmap quit_pix;

  /* First time flag for tiled */
  int tiled_first_time;

  /* GC and font stuff */
  GC tiled_gc;
  GC background_gc;

} Main_Window;

Main_Window *
init_control (Display *display, Demo_State *state);

/* Process the events for the window */
void
window_process (Main_Window *mw);

#endif
