/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.macos;

import java.awt.AWTError;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.TextEvent;
import java.awt.peer.TextFieldPeer;
import sun.awt.macos.MComponentPeer;
import sun.awt.macos.MToolkit;

public class MTextFieldPeer
extends MComponentPeer
implements TextFieldPeer {
    public MTextFieldPeer(TextField textField) {
        super(textField);
    }

    native void create(MComponentPeer var1);

    void initialize() {
        TextField textField = (TextField)this.target;
        this.setText(textField.getText());
        if (textField.echoCharIsSet()) {
            this.setEchoCharacter(textField.getEchoChar());
        }
        this.select(textField.getSelectionStart(), textField.getSelectionEnd());
        this.setEditable(textField.isEditable());
        super.initialize();
    }

    public void setBackground(Color color) {
        TextField textField = (TextField)this.target;
        if (textField.isEditable()) {
            color = color.brighter();
        }
        super.setBackground(color);
    }

    public native void setEditable(boolean var1);

    public native void select(int var1, int var2);

    public native int getSelectionStart();

    public native int getSelectionEnd();

    public native void setText(String var1);

    public native String getText();

    public native void setEchoCharacter(char var1);

    public void setEchoChar(char c) {
        this.setEchoCharacter(c);
    }

    public Dimension getPreferredSize(int n) {
        return this.preferredSize(n);
    }

    public Dimension getMinimumSize(int n) {
        return this.minimumSize(n);
    }

    public void setCaretPosition(int n) {
        throw new AWTError("setCaretPosition is unimplemented.");
    }

    public int getCaretPosition() {
        throw new AWTError("getCaretPosition is unimplemented.");
    }

    public Dimension minimumSize() {
        FontMetrics fontMetrics = this.getFontMetrics(this.target.getFont());
        return new Dimension(fontMetrics.stringWidth(((TextField)this.target).getText()) + 20, fontMetrics.getHeight() + 6);
    }

    public Dimension preferredSize(int n) {
        return this.minimumSize(n);
    }

    public Dimension minimumSize(int n) {
        FontMetrics fontMetrics = this.getFontMetrics(this.target.getFont());
        return new Dimension(fontMetrics.charWidth('0') * n + 20, fontMetrics.getHeight() + 6);
    }

    public void handleAction() {
        MToolkit.postEvent(new ActionEvent(this.target, 1001, this.getText()));
    }

    protected void handleTextChanged() {
        MToolkit.postEvent(new TextEvent(this.target, 900));
    }

    public boolean isFocusTraversable() {
        return true;
    }
}

