/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.macos;

import java.awt.AWTEvent;
import java.awt.Adjustable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.ScrollPane;
import java.awt.peer.ActiveEvent;
import java.awt.peer.ScrollPanePeer;
import sun.awt.macos.MComponentPeer;
import sun.awt.macos.MPanelPeer;
import sun.awt.macos.MToolkit;

class MScrollPanePeer
extends MPanelPeer
implements ScrollPanePeer {
    int scrollbarWidth = this._getVScrollbarWidth();
    int scrollbarHeight = this._getHScrollbarHeight();
    boolean ignore = false;

    native void create(MComponentPeer var1);

    native int getOffset(int var1);

    MScrollPanePeer(Component component) {
        super(component);
    }

    void initialize() {
        super.initialize();
        this.setInsets();
    }

    public void setUnitIncrement(Adjustable adjustable, int n) {
    }

    public Insets insets() {
        return this.getInsets();
    }

    private native void setInsets();

    public synchronized native void setScrollPosition(int var1, int var2);

    public int getHScrollbarHeight() {
        return this.scrollbarHeight;
    }

    private native int _getHScrollbarHeight();

    public int getVScrollbarWidth() {
        return this.scrollbarWidth;
    }

    private native int _getVScrollbarWidth();

    public Point getScrollOffset() {
        int n = this.getOffset(0);
        int n2 = this.getOffset(1);
        return new Point(n, n2);
    }

    public void childResized(int n, int n2) {
        ScrollPane scrollPane = (ScrollPane)this.target;
        Dimension dimension = scrollPane.getSize();
        this.setSpans(dimension.width, dimension.height, n, n2);
        this.setInsets();
    }

    synchronized native void setSpans(int var1, int var2, int var3, int var4);

    public void setValue(Adjustable adjustable, int n) {
        if (!this.ignore) {
            Component component = this.getScrollChild();
            Point point = component.getLocation();
            switch (adjustable.getOrientation()) {
                case 1: {
                    this.setScrollPosition(-point.x, n);
                    return;
                }
                case 0: {
                    this.setScrollPosition(n, -point.y);
                    return;
                }
            }
        }
    }

    private native Component getScrollChild();

    void scrolledVertical(int n) {
        ScrollPane scrollPane = (ScrollPane)this.target;
        Adjustable adjustable = scrollPane.getVAdjustable();
        if (adjustable != null) {
            Adjustor adjustor = new Adjustor(adjustable, n, this);
            MToolkit.postEvent(adjustor);
        }
    }

    void scrolledHorizontal(int n) {
        ScrollPane scrollPane = (ScrollPane)this.target;
        Adjustable adjustable = scrollPane.getHAdjustable();
        if (adjustable != null) {
            Adjustor adjustor = new Adjustor(adjustable, n, this);
            MToolkit.postEvent(adjustor);
        }
    }

    class Adjustor
    extends AWTEvent
    implements ActiveEvent {
        int value;
        Adjustable adj;
        MScrollPanePeer peer;

        Adjustor(Adjustable adjustable, int n, MScrollPanePeer mScrollPanePeer2) {
            super(adjustable, 0);
            MScrollPanePeer.this = MScrollPanePeer.this;
            this.adj = adjustable;
            this.value = n;
            this.peer = mScrollPanePeer2;
        }

        public void dispatch() {
            this.peer.ignore = true;
            this.adj.setValue(this.value);
            this.peer.ignore = false;
        }
    }
}

