/*
 * term.h: header file for term.c 
 *
 * Written By Michael Sandrof
 *
 * Copyright(c) 1990 
 *
 * See the COPYRIGHT file, or do a HELP IRCII COPYRIGHT 
 *
 * @(#)$Id: term.h,v 1.8 1994/07/02 02:38:10 mrg Exp $
 */

#ifndef _TERM_H_
# define _TERM_H_

#include "irc_std.h"
#include "screen.h"

extern	int	need_redraw;

#define current_ftarget (output_screen ? output_screen->fpout : stdout)


#ifdef WINNT

extern int underline, intensity, reverse;
#define term_underline_on()		underline = 1;
#define term_underline_off()		underline = 0;
#define term_standout_on()		reverse = 1;
#define term_standout_off()		reverse = 0;
#define term_clear_screen()		(tputs_x(CL))
#define term_cr()			(tputs_x(CR))
#define term_newline()			(tputs_x(NL))
#define	term_bold_on()			intensity = 1;
#define	term_bold_off()			intensity = 0;
#define term_blink_on()			;
extern        void    term_move_cursor        (int, int);
extern	int CO, LI;

#else

extern	char	*CM, *DO, *CE, *CL, *CR, *NL, *SO, *SE, *US, *UE, *MD, *ME, *BL, *MB;
extern	int	CO, LI, SG; 

static __inline__ void term_flush (void) { fflush(current_ftarget); }
static __inline__ int putchar_x (int c) { return fputc((int) c, current_ftarget); }


#define tputs_x(s)			(tputs(s, 0, putchar_x))
#define term_underline_on()		(tputs_x(US))
#define term_underline_off()		(tputs_x(UE))
#define term_standout_on()		(tputs_x(SO))
#define term_standout_off()		(tputs_x(SE))
#define term_blink_on()			(tputs_x(MB))

#ifdef __EMX__

extern int vio_screen;
/*#define term_move_cursor(c, r)  VioSetCurPos(r, c, 0)*/
#define term_move_cursor(c, r)      (tputs_x(tgoto(CM, (c), (r))))
extern char default_pair[2];
#define term_clear_screen()     VioScrollUp(0, 0, -1, -1, -1, &default_pair, vio_screen);

#else
#define term_clear_screen()     (tputs_x(CL))
#define term_move_cursor(c, r)      (tputs_x(tgoto(CM, (c), (r))))
#endif


#define term_cr()           (tputs_x(CR))
#define term_newline()			(tputs_x(NL))
#define	term_bold_on()			(tputs_x(MD))
#define	term_bold_off()			(tputs_x(ME))
#endif

extern	RETSIGTYPE term_cont 		_((int));
extern 	void 	term_beep 		_((void));
extern	int	term_echo 		_((int));
extern	int	term_init 		_((void));
extern	int	term_resize 		_((void));
extern	void	term_pause 		_((char, char *));
extern	void	term_putchar 		_((unsigned char));
extern	int	term_puts 		_((char *, int));
extern	void	term_flush 		_((void));
extern	int	(*term_scroll) 		_((int, int, int));
extern	int	(*term_insert) 		_((char));
extern	int	(*term_delete) 		_((void));
extern	int	(*term_cursor_right) 	_((void));
extern	int	(*term_cursor_left) 	_((void));
extern	int	(*term_clear_to_eol) 	_((void));
extern	void	term_space_erase 	_((int));
extern	void	term_reset 		_((void));

extern	int	term_eight_bit 		_((void));
extern	void	set_term_eight_bit 	_((int));



#endif /* _TERM_H_ */

