/*
 * IceWM
 *
 * Copyright (C) 1997 Marko Macek
 *
 * Window list
 */

#include "icewm.h"

#define HORZ 10
#define MIDH 10
#define VERT 10

CtrlAltDelete::CtrlAltDelete(YWindow *parent): YWindow(parent) {
    unsigned int w = 0, h = 0;
    YButton *b;
    
    setStyle(wsOverrideRedirect);
    
    b = lockButton = new YButton(this, cmdNone, 0);
    b->setText((char *)"Lock Workstation");
    if (b->width() > w) w = b->width();
    if (b->height() > h) h = b->height();
    b->setListener(this);
    b->show();
    b = logoutButton = new YButton(this, cmdNone, 0);
    b->setText((char *)"Close Session");
    if (b->width() > w) w = b->width();
    if (b->height() > h) h = b->height();
    b->setListener(this);
    b->show();
    b = cancelButton = new YButton(this, cmdNone, 0);
    b->setText((char *)"Cancel");
    if (b->width() > w) w = b->width();
    if (b->height() > h) h = b->height();
    b->setListener(this);
    b->show();

    setSize(HORZ + w + MIDH + w + MIDH + w + HORZ,
            VERT + h + VERT);
    setPosition((app->root()->width() - width()) / 2,
                (app->root()->height() - height()) / 2);

    lockButton->setGeometry(HORZ, VERT, w, h);
    logoutButton->setGeometry(HORZ + w + MIDH, VERT, w, h);
    cancelButton->setGeometry(HORZ + w + MIDH + w + MIDH, VERT, w, h);
}

CtrlAltDelete::~CtrlAltDelete() {
    delete lockButton;
    delete logoutButton;
    delete cancelButton;
}

void CtrlAltDelete::paint(Graphics &g, int /*x*/, int /*y*/, unsigned int /*width*/, unsigned int /*height*/) {
    g.setColor(taskBarBg);
    g.draw3DRect(0, 0, width() - 1, height() - 1, true);
    g.fillRect(1, 1, width() - 2, height() - 2);
}

void CtrlAltDelete::ButtonClick(YButton *button) {
    deactivate();
    if (button == lockButton) {
    } else if (button == logoutButton) {
        app->exit(0);
    } else if (button == cancelButton) {
    }
}

void CtrlAltDelete::activate() {
    raise();
    show();
    if (!app->grabEvents(this, None,
                         ButtonPressMask |
                         ButtonReleaseMask |
                         ButtonMotionMask /*|
                         EnterWindowMask |
                         LeaveWindowMask*/, 1, 1, 1))
        hide();
}

void CtrlAltDelete::deactivate() {
   app->releaseEvents();
   hide();
}
