/*****************************************************************************/
/*  Includes                                                                 */
/*****************************************************************************/

#include <string.h>
#include "version.h"
#include <stdio.h>


#ifdef USE_SIOUX
#  include <sioux.h>
#  include <signal.h>
#  include <stdlib.h>
#  include <console.h>
#endif /* USE_SIOUX */


/*****************************************************************************/
/*  Global Vars                                                              */
/*****************************************************************************/

char fileList[256];


/*****************************************************************************/
/*  Prototypes                                                               */
/*****************************************************************************/

int UzpMain(int argc,char **argv);

char *GetUnZipLocalVersion(void);
char *GetUnZipInfoVersions(void);
int  macgetch(void);
void UserStop(void);



/*****************************************************************************/
/*  Functions                                                                */
/*****************************************************************************/

#ifndef MacStaticLib
#ifndef MACUNZIP_STANDALONE

/*
Program execution starts here with Metrowerks SIOUX-Console */
int main(int argc,char **argv)
{
    int return_code;

    SIOUXSettings.asktosaveonclose = FALSE;
    SIOUXSettings.showstatusline = TRUE;

    SIOUXSettings.columns = 100;
    SIOUXSettings.rows    = 40;

    argc = ccommand(&argv);

    return_code = UzpMain(argc,argv);

    printf("\n\n Finish  %d",return_code);

    return return_code;
}



int macgetch(void)
{
    WindowPtr whichWindow;
    EventRecord theEvent;
    char c;                     /* one-byte buffer for read() to use */

    do {
        SystemTask();
        if (!GetNextEvent(everyEvent, &theEvent))
            theEvent.what = nullEvent;
        else {
            switch (theEvent.what) {
            case keyDown:
                c = theEvent.message & charCodeMask;
                break;
            case mouseDown:
                if (FindWindow(theEvent.where, &whichWindow) ==
                    inSysWindow)
                    SystemClick(&theEvent, whichWindow);
                break;
            case updateEvt:
                break;
            }
        }
    } while (theEvent.what != keyDown);

    printf("*");
    fflush(stdout);

    return (int)c;
}


/* SIOUX needs no extra event handling */
void UserStop(void)
{
}

#endif  /*   #ifndef MACUNZIP_STANDALONE  */
#endif  /*   #ifndef MacStaticLib   */




char *GetUnZipLocalVersion(void)
{
static char UnZipVersionLocal[50];

memset(UnZipVersionLocal,0,sizeof(UnZipVersionLocal));

sprintf(UnZipVersionLocal, "[%s %s]", __DATE__, __TIME__);

return UnZipVersionLocal;
}




char *GetUnZipInfoVersions(void)
{
static char UnzipVersion[200];

memset(UnzipVersion,0,sizeof(UnzipVersion));

sprintf(UnzipVersion, "Unzip Module\n%d.%d%d%s of %s", UZ_MAJORVER,
        UZ_MINORVER, PATCHLEVEL, BETALEVEL, VERSION_DATE);

return UnzipVersion;
}
