#
# NAME:		test1
# DESCRIPTION:	fragment two files to excess
#
proc test1 {} {
    global curvol

    set block [block]

    mkvol

    puts "Creating files ..."

    set file1 "Foo"
    set file2 "Bar"

    hcreate $file1
    hcreate $file2

    puts "Fragmenting files ..."

    set count 0

    for {set i 0} {$i < 250} {incr i} {
	set len [string length "$i "]

	if {[expr $count + $len] > 79} {
	    puts ""
	    set count 0
	}

	puts -nonewline "$i "
	flush stdout
	incr count $len

	set file [$curvol open $file1]

	$file fork data
	$file seek 0 end
	$file write $block

	$file fork rsrc
	$file seek 0 end
	$file write $block

	$file close

	set file [$curvol open $file2]

	$file fork data
	$file seek 0 end
	$file write $block

	$file fork rsrc
	$file seek 0 end
	$file write $block

	$file close
    }

    puts ""
}
