#include <stdio.h>
#include "file2.h"

/*
 * buffers for stdin, stdout, and stderr
 */

#ifndef COFF_LIBRARY
unsigned char    _bufin  [BUFSIZ];
unsigned char    _bufout [BUFSIZ];
#endif
unsigned char    _buferr [BUFSIZ];

/*
 *  Status if a file is known to be or known not to be a tty
 */

unsigned char tty_flag_list [_NFILE] = { 0 };

/*
 *  Current index number for the temporary file name
 */

unsigned int _tempIndex = 0;

/*
 *   Number of buffers which are pending a flush operation
 */

unsigned int _cflush = 0;

/*
 *    FILE descriptors; preset for stdin/out/err
 */

#ifndef COFF_LIBRARY
#ifdef _STDIO_REVERSE
FILE _iob[ _NFILE ] = {
    /*	ptr,		cnt,	base,		flag,		file */
    {
	_bufin,		0,	_bufin,		_IOREAD,	0 }
    ,
    {
	_bufout,	0,	_bufout,	_IOWRT,		1 }
    ,
    {
	NULL,		0,	NULL,		_IOWRT,		2 }
    ,
};
#else
FILE _iob[ _NFILE ] = {
    /*	cnt,	ptr,	    	base,		flag,		file */
    {
	0,	_bufin,		_bufin,		_IOREAD,	0 }
    ,
    {
	0,	_bufout,	_bufout,	_IOWRT,		1 }
    ,
    {
	0,	NULL,		NULL,		_IOWRT,		2 }
    ,
};
#endif
#endif

/* I think the COFF libraries may need this as well.  I do not know how they
   get by without it, as a matter of fact.

   Eric, the bufendtab table wasn't needed for the COFF library because the
   COFF library used the count in the FILE2 structure. It was changed because
   the library definition was further clarified. Al.
*/

#ifdef COFF_LIBRARY
#undef	_bufendtab
#define _bufendtab	bufendtab
#define FIRST_BUFFER	(unsigned char *) 0
#define SECOND_BUFFER	(unsigned char *) 0
#else
#define FIRST_BUFFER	&_bufin[BUFSIZ-1]
#define SECOND_BUFFER	&_bufout[BUFSIZ-1]
#endif

unsigned char * _bufendtab[_NFILE] = { 
  FIRST_BUFFER, SECOND_BUFFER,};

#ifdef ELF_LIBRARY
__asm__(".weak _iob;_iob = __iob");
#endif

/* pointer to end of descriptors */
#ifndef COFF_LIBRARY
FILE * _lastiob = &_iob[ _NFILE -1];
#endif
