/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport;

import java.io.IOException;
import java.io.PrintStream;
import java.rmi.MarshalException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.LogStream;
import java.rmi.server.ObjID;
import java.rmi.server.RemoteCall;
import java.rmi.server.RemoteServer;
import java.rmi.server.ServerNotActiveException;
import sun.rmi.server.Dispatcher;
import sun.rmi.transport.Channel;
import sun.rmi.transport.Endpoint;
import sun.rmi.transport.ObjectTable;
import sun.rmi.transport.Target;
import sun.rmi.transport.Utils;

public abstract class Transport {
    static int logLevel = Transport.getLogLevel();

    private static int getLogLevel() {
        SecurityManager.enablePrivilege((String)"UniversalPropertyRead");
        return LogStream.parseLevel(Utils.getProperty("sun.rmi.transport.logLevel"));
    }

    public abstract Channel getChannel(Endpoint var1);

    public abstract Endpoint thisEndpoint();

    public void exportObject(ObjID objID, Target target) throws RemoteException {
        ObjectTable.putTarget(objID, target);
    }

    public boolean serviceCall(RemoteCall remoteCall) {
        Dispatcher dispatcher;
        Remote remote;
        try {
            Target target;
            ObjID objID;
            if (logLevel >= 20) {
                LogStream.log("transport").println("Transport.serviceCall: waiting to read object id");
            }
            try {
                objID = ObjID.read(remoteCall.getInputStream());
            }
            catch (IOException iOException) {
                throw new MarshalException("unable to read objID", iOException);
            }
            if (logLevel >= 10) {
                LogStream.log("transport").println("Transport.serviceCall: get target " + objID);
            }
            if ((target = ObjectTable.getTarget(objID)) == null || (remote = target.getImpl()) == null) {
                throw new NoSuchObjectException("no such object in table");
            }
            dispatcher = target.getDispatcher();
        }
        catch (RemoteException remoteException) {
            AutoCloseable autoCloseable;
            PrintStream printStream = RemoteServer.getLog();
            if (printStream != null) {
                autoCloseable = printStream;
                synchronized (autoCloseable) {
                    try {
                        printStream.print("[" + RemoteServer.getClientHost() + "] ");
                    }
                    catch (ServerNotActiveException serverNotActiveException) {}
                    printStream.print("exception: ");
                    remoteException.printStackTrace(printStream);
                }
            }
            try {
                if (logLevel >= 10) {
                    autoCloseable = LogStream.log("transport");
                    ((PrintStream)autoCloseable).println("Transport.serviceCall: exception: ");
                    remoteException.printStackTrace((PrintStream)autoCloseable);
                }
                autoCloseable = remoteCall.getResultStream(false);
                autoCloseable.writeObject(remoteException);
                remoteCall.releaseOutputStream();
            }
            catch (IOException iOException) {
                return false;
            }
            return true;
        }
        try {
            if (logLevel >= 20) {
                LogStream.log("transport").println("Transport.serviceCall: call dispatcher");
            }
            dispatcher.dispatch(remote, remoteCall);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }
}

