#include <config.h>

#ifdef PAM

#include "rcsid.h"
RCSID("$Id: pam_pass.c,v 1.1 1997/09/29 22:01:20 marekm Exp $")

/*
 * Change the user's password using PAM.  Requires libpam and
 * libpam_misc (for misc_conv).  --marekm
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <security/pam_appl.h>
#include <security/pam_misc.h>

static struct pam_conv conv = {
	misc_conv,
	NULL
};

void
do_pam_passwd(user, silent, change_expired)
	const char *user;
	int silent;
	int change_expired;
{
	pam_handle_t *pamh = NULL;
	int flags = 0, ret;

	if (silent)
		flags |= PAM_SILENT;
	if (change_expired)
		flags |= PAM_CHANGE_EXPIRED_AUTHTOK;

	ret = pam_start("passwd", user, &conv, &pamh);
	if (ret != PAM_SUCCESS)
		goto failure;

	ret = pam_chauthtok(pamh, flags);
	if (ret != PAM_SUCCESS) {
		pam_end(pamh, ret);
		goto failure;
	}

	ret = pam_end(pamh, PAM_SUCCESS);
	if (ret != PAM_SUCCESS) {
failure:
		fprintf(stderr, "passwd: %s\n", pam_strerror(ret));
		exit(1);
	}
}
#endif /* PAM */
