/*
 * runlevel	Prints out the previous and the current runlevel.
 *
 * Version:	@(#)runlevel  1.10  29-Feb-1996  MvS
 *
 *		This file is part of the sysvinit suite,
 *		Copyright 1991-1996 Miquel van Smoorenburg.
 *
 *		This program is free software; you can redistribute it and/or
 *		modify it under the terms of the GNU General Public License
 *		as published by the Free Software Foundation; either version
 *		2 of the License, or (at your option) any later version.
 */

#include <stdio.h>
#include <utmp.h>
#include <time.h>
#include <stdlib.h>

int main(argc, argv)
int argc;
char **argv;
{
  FILE *fp;
  struct utmp ut;
  char *file = UTMP_FILE;
  char prev;

  if (argc > 1) file = argv[1];
  if ((fp = fopen(file, "r")) != NULL) {
    while (fread(&ut, sizeof(struct utmp), 1, fp) == 1) {
	if (ut.ut_type == RUN_LVL) {
		prev = ut.ut_pid / 256;
		if (prev == 0) prev = 'N';
		printf("%c %c\n", prev, ut.ut_pid % 256);
		fclose(fp);
		exit(0);
	}
    }
  }
  
  printf("unknown\n");
  if (fp) fclose(fp);
  return(1);
}
