 
#ifndef lint
static char sccsid[] = "@(#)sphere2.c 3.11h 96/09/30 xlockmore";
 
#endif
 
/*-
 * sphere2.c - sphere2 for xlock, the X Window System lockscreen.
 *
 * Copyright (c) 1995 by Charles Vidal <vidalc@univ-mlv.fr>
 *         http://fillmore.univ-mlv.fr/~vidalc
 *
 * See xlock.c for copying information.
 */

#include "xlock.h"
#include <math.h>


#define XVAL 160.0
#define YVAL 128.0
#define DVAL 100.0
#define RVAL 50.0
#define TVAL 60.0
#define W	320
#define H	250
#define NB_POINT 625
#define FACTOR 8.0
#define FACTORINT 8
#define COEF 25

ModeSpecOpt sphere2_opts =
{0, NULL, 0, NULL, NULL};

static double xcentre, ycentre, distance;
static int  n1, n2;
static double t[NB_POINT], u[NB_POINT], v[NB_POINT], t1[NB_POINT], u1[NB_POINT],
            v1[NB_POINT];
static XPoint p[NB_POINT];
static XPoint p2[NB_POINT];
static unsigned long blanc, noir;
static double alp, teta, phi, r;
static int  x_sphere = 0, y_sphere = 0;
static int  x_direct = 5, y_direct = 5;
static int  count4p = 0;
static Pixmap cache;
static int  Taillew, Tailleh;

static void
creersphere(double *t, double *u, double *v, double r, int n1, int n2)
{
	double      i, j;
	int         n = 0;

	for (i = 0; i < FACTORINT * M_PI; i += (FACTORINT * M_PI) / n1)
		for (j = 0; j < FACTORINT * M_PI; j += (FACTORINT * M_PI) / n2) {
			t[n] = r * cos(i) * cos(j);
			u[n] = r * cos(i) * sin(j);
			v[n] = r * sin(i);
			n++;
		}
}

static void
_3drotation(double *t, double *u, double *v, int n, double alp, double teta, double phi)
{
	double      c1, c2, c3, c4, c5, c6, c7, c8, c9, x, y, z;
	int         i;

	c1 = cos(phi) * cos(teta);
	c2 = sin(phi) * cos(teta);
	c3 = -sin(teta);

	c4 = cos(phi) * sin(teta) * sin(alp) - sin(phi) * cos(alp);
	c5 = sin(phi) * sin(teta) * sin(alp) + cos(phi) * cos(alp);
	c6 = cos(teta) * sin(alp);

	c7 = cos(phi) * sin(teta) * cos(alp) + sin(phi) * sin(alp);
	c8 = sin(phi) * sin(teta) * cos(alp) - cos(phi) * sin(alp);
	c9 = cos(teta) * cos(alp);
	for (i = 0; i < n; i++) {
		x = t[i];
		y = u[i];
		z = v[i];
		t[i] = c1 * x + c2 * y + c3 * z;
		u[i] = c4 * x + c5 * y + c6 * z;
		v[i] = c7 * x + c8 * y + c9 * z;
	}
}
/* 
   static void projete(t, u, v, p, n) double     *t, *u, *v; XPoint     *p;
   int         n; { int         i;

   for (i = 0; i < n; i++) { if (v[i] == 0.0) { p[i].x = 0; p[i].y = 0; } else 




   { p[i].x = (short) (xcentre + distance * (t[i] / (v[i] + TVAL))); p[i].y =
   (short) (ycentre + distance * (u[i] / (v[i] + TVAL))); } } } */
static void
projete2(double *t, double *u, /*double *v,*/ XPoint * p, int n)
{
	int         i;

	for (i = 0; i < n; i++) {
		p[i].x = (short) (xcentre + 2 * t[i]);
		p[i].y = (short) (ycentre + 2 * u[i]);
	}
}

void
init_sphere2(ModeInfo * mi)
{
	Display    *display = MI_DISPLAY(mi);

	noir = MI_WIN_BLACK_PIXEL(mi);
	blanc = MI_WIN_WHITE_PIXEL(mi);

	xcentre = XVAL;
	ycentre = YVAL;
	distance = DVAL;
	r = RVAL;
	if (!(cache = XCreatePixmap(display, MI_WINDOW(mi), W, H, MI_WIN_DEPTH(mi))))
		(void) printf("catastrophe memoire\n");

#if 0
	gcv.foreground = blanc;
	gcv.background = noir;
	gcv.function = GXcopy;
	gcv.line_width = 6;
	gcmask = GCForeground | GCBackground | GCLineWidth |
		GCFunction;
	gcontext = XCreateGC(display, cache, gcmask, &gcv);

	gcv2.foreground = noir;
	gcv2.background = blanc;
	gcv2.function = GXcopy;
	g2 = XCreateGC(display, cache, GCForeground | GCBackground | GCFunction,
		       &gcv2);
#endif
	alp = 0;
	teta = 0;
	phi = 0;
	n1 = n2 = COEF;
	creersphere(t1, u1, v1, r, n1, n2);
	Taillew = MI_WIN_WIDTH(mi);
	Tailleh = MI_WIN_HEIGHT(mi);
	XClearWindow(display, MI_WINDOW(mi));
	XSetForeground(display, MI_GC(mi), MI_WIN_BLACK_PIXEL(mi));
}

void
draw_sphere2(ModeInfo * mi)
{
	Display    *display = MI_DISPLAY(mi);
	Window      window = MI_WINDOW(mi);
	GC          gc = MI_GC(mi);
	int         i, j;

	/*unsigned long gcmask; */

/* noir=MI_WIN_BLACK_PIXEL(mi); blanc=MI_WIN_WHITE_PIXEL(mi); */

/* XCopyArea(display, cache, window, gc,0,0,W,H,x_sphere,y_sphere);
   XFillRectangle(display, cache, gc,0,0,W,H); */
/* XFlush(display); */
	for (i = 0; i < NB_POINT; i++) {
		t[i] = t1[i];
		u[i] = u1[i];
		v[i] = v1[i];
	}
	alp += ((FACTOR * M_PI) / 200.0);
	teta += ((FACTOR * M_PI) / 200.0);
	phi += ((FACTOR * M_PI) / 200.0);
	if (alp > (FACTOR * M_PI))
		alp -= (FACTOR * M_PI);
	if (teta > (FACTOR * M_PI))
		teta -= (FACTOR * M_PI);
	if (phi > (FACTOR * M_PI))
		phi -= (FACTOR * M_PI);

	_3drotation(t, u, v, NB_POINT, alp, teta, phi);
	projete2(t, u, /*v,*/ p, NB_POINT);
	j = 0;
/* XSetForeground(display, gc, MI_WIN_BLACK_PIXEL(mi));
   XFillRectangle(display,window,gc,x_sphere,y_sphere,W,H); */
	for (i = 0; i < NB_POINT; i++) {
		if (v[i] > 0.0) {
			p2[j].x = p[i].x + x_sphere;
			p2[j].y = p[i].y + y_sphere;
			j++;
		}
	}
	count4p = (count4p + 1) % MI_NPIXELS(mi);
	XSetForeground(display, gc, MI_PIXEL(mi, count4p));
	XDrawPoints(display, window, gc, p2, j, CoordModeOrigin);
	if (x_sphere + XVAL + DVAL > Taillew)
		x_direct = -5;
	if (x_sphere < 0)
		x_direct = 5;
	if (y_sphere + YVAL + DVAL > Tailleh)
		y_direct = -5;
	if (y_sphere < 0)
		y_direct = 5;
	x_sphere += x_direct;
	y_sphere += y_direct;
}

void
release_sphere2(ModeInfo * mi)
{
}
