/*
 * Copyright (c) 1983 Eric P. Allman
 * Copyright (c) 1988 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted provided
 * that: (1) source distributions retain this entire copyright notice and
 * comment, and (2) distributions including binaries display the following
 * acknowledgement:  ``This product includes software developed by the
 * University of California, Berkeley and its contributors'' in the
 * documentation or other materials provided with the distribution and in
 * all advertising materials mentioning features or use of this software.
 * Neither the name of the University nor the names of its contributors may
 * be used to endorse or promote products derived from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

/*
**  NEWSOS5.H -- configurable parameters for sendmail on Sony NewsOS 5.x.x
**              platforms, compilation is BSD emulation. This should work
**              on other SVR4 boxes with BSD emulation.
*/

#define VMUNIX		0	/* running on systems w. 4.2/4.3 networking */
#define SYSV		1	/* running on a system 5 system */
#define SVR4		1	/* running on a system 5 release 4 system */
#define SIG_TYPE	void	/* Value returned by signal() */
#define TIME_TYPE	time_t	/* Value used and returned by time() */
#define FCNTL_FLOCK	1	/* Berkeley flock() emulation using fcntl() */
#define HAVE_UNAME	1	/* System has the uname() call */
#define HAVE_WAITPID	1	/* has the waitpid() call */
#define LACK_SIGBLOCK	1	/* sigblock() is missing.  Use sigprocmask() */

/* Define following if compiling using BSD emulation */
#define SVR4BSD		1	/* To use the correct (BSD) direct/dirent */
#define SYSTYPE_BSD43	1	/* BSD emulation */
#define DSYSTYPE_BSD	1	/* Hipps the same */
#undef  SYSTYPE_SYSV	1	/* And again... */
#define LOG_BUFSIZE	60	/* Buffer for syslog() calls in logdelivery() */
