#! /usr/local/bin/perl

# Print a weekly summary of email activity.  Written by Paul Vixie, DEC

$logdir = "/usr/spool/mqueue";
$secperday = 24 * 60 * 60;
$shortdelay = $secperday / 2;
$K = 1024;


format q_top =
 Syslog    Input: (total)      (mail11)     Output Statistics:
File Date  Msgs Kbytes AvgSz  Sndrs Rcips   Sent AvgDelay Dferd Que'd Other
.
format q_line =
@< @<<<<< @>>>> @>>>>> @>>>>  @>>>> @>>>>  @>>>> @>>>>>>> @>>>> @>>>> @>>>>
$logfn,$date,$msgs,$kbytes,$avgsiz,$m11sndr,$m11rcip,$sent,$avgdly,$dferd,$queued,$other
.

$^ = "q_top";
$~ = "q_line";

chdir($logdir) || die "can't chdir to $logdir: $!";
foreach $logfn (<syslog.*>) {
	open(stdin, "<$logfn") || die "can't open $logfn: $!";
	&mailstats();
	close(stdin);
	$logfn =~ s/^.*\./\./;
	write();
}

exit(0);

sub mailstats {
($msgs,$bytes,$delay,$m11sndr,$m11rcip) = (0,0,0,0,0);
$date = "";
%stati = ();
while (<>) {
	($mon,$dd,$time,$host,$client,$qid,@rest) = split;
	@rest=split(/, /,join(' ',@rest));
	$date = sprintf("%s %2d", $mon, $dd) if ($date eq "");
	if ($client =~ /sendmail\[[0-9]+\]:/) {
		if ($rest[0] =~ /^from=/ && $rest[1] =~ /^size=(\d+)/) {
			$msgs++;
			$bytes += $1;
		} elsif ($rest[0] =~ /^to=/) {
			if ($rest[2] =~ /Deferred/) {
				if ($deferred{$qid}) {
					next;
				} else {
					$deferred{$qid}++;
				}
			}
			$rest[1] =~ /^delay=([^,]+)/;
			$md = $1;
			$d = 0;
			if ($md =~ /(\d+)\+(.+)/) {
				$d += $md * $secperday;
				$md =~ s/\d+\+//;
			}
			$md =~ /^delay=(\d+):(\d+):(\d+)/;
			$d += ($1 * 3600 + $2 * 60 + $3);
			$delay += $d if ($d < $shortdelay);
			$rest[2] =~ /^stat=(.+)(.*)/;
			$stat = $1." ".$2;
			$stati{$stat}++;
		}
	}
	if ($client eq "mail11d:") {
		if ($rest[0] =~ /^from=/) {
			$m11sndr++;
		} elsif ($rest[0] =~ /^to=/) {
			$m11rcip++;
		}
	}
}

#printf	"total input: %d msgs, %dKB (%d bytes avg)\n",
#	$msgs, $bytes/$K, $bytes/$msgs;

#printf	"mail11 input: %d senders (msgs), %d recips\n",
#	$mail11_senders, $mail11_recips;

if ($msgs == 0) {
	$avgdly = &fmt_time(0);
} else {
	$avgdly = &fmt_time($delay / $msgs);
}

$kbytes = int(0.5+$bytes/$K);
if ($msgs == 0) {
	$avgsiz = 0;
} else {
	$avgsiz = int(0.5+$bytes/$msgs);
}
$sent = $stati{"Sent "};

($dferd, $other, $queued) = (0, 0, 0);
foreach $stat (keys(%stati)) {
	next if ($stat eq "Sent ");
	if ($stat eq "queued ") {
		$queued += $stati{$stat};
		next;
	}
	if ($stat =~ /^Deferred/) {
		$dferd += $stati{$stat};
		next;
	}
	$other += $stati{$stat};
}
return;
}

sub fmt_time {
	local($t) = @_;
	local($s) = int($t);
	local($h) = int($s / 3600);  $s -= $h*3600;
	local($m) = int($s / 60);  $s -= $m*60;
	local($x) = "";

	if ($s || $m || $h) {
		$x = sprintf("%02d", $s) .$x;
	}
	if ($m || $h) {
		$x = sprintf("%02d:", $m) .$x;
	}
	if ($h) {
		$x = sprintf("%2d:", $h) .$x;
	}
	return $x;
}
