# ----------------------------------------------------------------------
#  PURPOSE:  Class definition for handling "smart" toasters via
#            [incr Tcl].  A "smart" toaster is a toaster that
#            automatically cleans itself when the crumb tray is full.
#
#   AUTHOR:  Michael J. McLennan       Phone: (215)770-2842
#            AT&T Bell Laboratories   E-mail: aluxpo!mmc@att.com
#
#     SCCS:  @(#)SmartToaster.tcl	1.1 (7/22/93)
# ----------------------------------------------------------------------
#            Copyright (c) 1993  AT&T  All Rights Reserved
# ======================================================================

itcl_class SmartToaster {
	inherit Toaster

	method toast {nslices} {
		if {$crumbs >= [expr $maxcrumbs-10]} {
			clean
		}
		return [Toaster::toast $nslices]
	}
}
