# 8/8/2019

### Attending:

* Cary Phillips
* Kimball Thurston
* Nick Porcino
* Christina Tempelaar-Leitz
* Joseph Goldstone
* Arkell Rasiah
* Robert Pancoast

### Agenda:

* 2.3.1 release
   * Windows build?
   * Confirm the proper so version?
   * Mitre.org’s CVE posting
   * When to create a beta tag?

* ASWF project adoption
   * CII badge progress is 95%
   * Security questions (-x option a solution for memory consumption?)
   * Dynamic analysis

* Status of CLA signage

* SIGGRAPH BoF followup
   * How to turn the discussion into a “roadmap”
   * Proposed new features/initiatives:
      * Stateless read
      * Part ordering
      * Published compression standards
      * Streaming performance
      * 32-bit compression
      * Integer images
      * Bfloat16
      * In-place metadata edit

* Next up:
   * Repo move
   * Imath repo
   * C++11
   * pybind11
   * Clang-tidy
   * SonarCloud “bugs”
   * Test coverage
   * Website refresh

### Discussion:

* Looks like Arkell and Joseph have independently written a utility
  for reading exr headers into a stringstream for in-memory
  manipulation of metadata. They should work on resolving and submit
  it to include in the library.

* Joseph: No order is imposed on metadata; metadata is stored as
  a map, it needs a lexical ordering.

* The “image” metadata field is a MD5 checksum on the image. Kimball:
  I tend to strip out checksums because it’s almost immediately
  invalid. Joseph: should it be dropped entirely? Piz compression
  generates different byte streams when compression tables have
  multiple unique entries because the sort isn’t stable, which yields
  different checksums for identical images. Arkell has a fix, he’ll
  submit it.

* SMPTE 2065-4 doesn’t standardize all of OpenEXR, it’s just a
  subset. ACES only took the minimum items that were necessary; it
  doesn’t include multi-part or deep. Does anyone care? The only
  reason you’d care is if you want the ACES logo on your project to
  certify that it handles EXR’s. But SMPTE doesn’t accept code as the
  definition of a standard, it would require explicit documentation,
  which would be a lot of work, and would then lock in that
  specification as the standard that the code would have to abide by.

* Joseph: Is there a potential connection to the mention of a
  “tinyexr”? Should that be the ACES container file but that you’re
  free to use? Kimball: the “tiny” of the notion of “tinyexr” refers
  to the size and magnitude of the source code of the library, not the
  supported contents of the file.  Conclusion: When/if there is
  consideration of a stream-lined exr library, we should at least
  discuss the SMPTE standards issue.

* Conclusion: if this is a priority for someone, or someone puts forth
  a compelling argument for standardization, then someone would need
  to step up and pursue SMPTE standardization.

* The 2.3.1 release is ABI-compatible, so won’t need to update so version.

* Christina will leave some comments on Robert’s PR related to the
  Windows build in the Azure pipeline.

* We should consider a target that runs valgrind on the unit
  tests. Can add a prefix command, then run w/valgrind in front of it.

* Robert: MSbuild has a command-line switch to run “code analysis,” it
  should be built into Azure.

