/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at <http://mozilla.org/MPL/2.0/>. */

// @flow

import SourceEditor from "./source-editor";
import { features, prefs } from "../prefs";

export function createEditor(): SourceEditor {
  const gutters = ["breakpoints", "hit-markers", "CodeMirror-linenumbers"];

  if (features.codeFolding) {
    gutters.push("CodeMirror-foldgutter");
  }

  return new SourceEditor({
    mode: "javascript",
    foldGutter: features.codeFolding,
    enableCodeFolding: features.codeFolding,
    readOnly: true,
    lineNumbers: true,
    theme: "mozilla",
    styleActiveLine: false,
    lineWrapping: prefs.editorWrapping,
    matchBrackets: true,
    showAnnotationRuler: true,
    gutters,
    value: " ",
    extraKeys: {
      // Override code mirror keymap to avoid conflicts with split console.
      Esc: false,
      "Cmd-F": false,
      "Ctrl-F": false,
      "Cmd-G": false,
      "Ctrl-G": false,
    },
    cursorBlinkRate: prefs.cursorBlinkRate,
  });
}

export function createHeadlessEditor(): SourceEditor {
  const editor = createEditor();
  editor.appendToLocalElement(document.createElement("div"));
  return editor;
}
